/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateOld=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),ts_api_1=require("../ts-api"),node_state_1=require("./node-state"),state_load_1=require("./state-load");class StateOld{static async keepOldState(t){if(t.oldState)return;if(t.isThunk)await state_load_1.StateLoad.load(t);t.oldState=new node_state_1.NodeState(t.context,t.factory,t.values,node_state_1.StateStatus.readonly,{isOld:true,isOnlyForDefaultValues:t.isOnlyForDefaultValues,isOnlyForDuplicate:t.isOnlyForDuplicate,isOnlyForLookup:t.isOnlyForLookup}),t.values={...t.values}}static async getOldState(t){if(t.status===node_state_1.StateStatus.created||t.status===node_state_1.StateStatus.inserted)throw new Error("'old' not accessible in creation status");if(t.isReadonly)return t;return await StateOld.keepOldState(t),t.oldState}static mapNodeIfOld(t,e,a){if(!a)return a;if(!e.isVitalParent&&!e.isAssociationParent&&!e.isMutable)return a;if(!t.isOld)return a;if(a.$.state.isOld)return a;if(a.$.status===ts_api_1.NodeStatus.added)return a;return a.$.old}static async mapNodesIfOld(t,e,a){if(!t.isOld)return a;return await(0,xtrem_async_helper_1.asyncArray)(a).map(a=>StateOld.mapNodeIfOld(t,e,a)).toArray()}}exports.StateOld=StateOld;
//# sourceMappingURL=state-old.js.map