/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateNew=void 0;const utils_1=require("../runtime/utils"),node_state_1=require("./node-state"),state_intern_1=require("./state-intern"),state_load_1=require("./state-load"),state_utils_1=require("./state-utils");class StateNew{static async findConcreteFactory(t,e,a,n){if(t.values[`_${a.name}_constructor`])return t.context.application.getFactoryByName(t.values[`_${a.name}_constructor`]);const r=await t.context.executeSql(`SELECT _constructor from ${t.context.schemaName}.${e.table.sqlTableName} where _tenant_id = $1 and _id = $2`,[t.context.tenantId,n]);if(!r[0])throw e.systemError(`${n}: read _constructor failed`);return t.values[`_${a.name}_constructor`]=r[0]._constructor,t.context.application.getFactoryByName(r[0]._constructor)}static async newReferenceThunk(t,e,a,n,r){if(e.isAbstract&&"number"==typeof n._id&&n._id>0){const s=await StateNew.findConcreteFactory(t,e,a,n._id);n._constructor=s.name;const o=await StateNew.newReferenceThunk(t,s,a,n,r);return state_intern_1.StateIntern.intern(o)}const s=r?node_state_1.StateStatus.updatable:node_state_1.StateStatus.readonly,o=new node_state_1.NodeState(t.context,e,n,s,{isThunk:true});return state_intern_1.StateIntern.intern(o)}static newConcreteState(t,e,a){if(!e.factory.isAbstract)return e;if(!e.values._constructor)throw e.factory.systemError("cannot create concrete node (_constructor is missing)");const n=t.application.getFactoryByName(e.values._constructor);return new node_state_1.NodeState(t,n,e.values,e.isReadonly?node_state_1.StateStatus.readonly:node_state_1.StateStatus.updatable,{...a,isThunk:true})}static newFromQuery(t,e,a,n){const r=n?node_state_1.StateStatus.updatable:node_state_1.StateStatus.readonly,s={forUpdate:n};let o=new node_state_1.NodeState(t,e,a,r,s);if(e.isAbstract)o=StateNew.newConcreteState(t,o,s);return o.setLazyLoadMarkers(),n?state_intern_1.StateIntern.intern(o):o}static getReadKeyValues(t,e,a){if(a&&(0,utils_1.isCompound)(a))return a;if("external"===e.storage)return e.externalStorageManager.getKeyValues(t,a);return{_id:a}}static async newFromRead(t,e,a,n){const r={...n},s=!!r.forUpdate;if(s&&!t.isWritable)throw e.systemError("cannot read for update: context is readonly");const o=StateNew.getReadKeyValues(t,e,a),u=s?node_state_1.StateStatus.updatable:node_state_1.StateStatus.readonly,i={forUpdate:s,isThunk:true,isTransient:r.isTransient,isOnlyForLookup:r.isOnlyForLookup};let c=new node_state_1.NodeState(t,e,o,u,i);const d=Object.values(state_intern_1.StateIntern.getInterningKeysFromValues(c.factory,o));if(c=state_intern_1.StateIntern.intern(c),!await state_load_1.StateLoad.tryLoad(c)){if(r.dontThrow)return null;if(c.status===node_state_1.StateStatus.unauthorized)throw c.dataInputError({message:"Unauthorized: {{values}}",key:"@sage/xtrem-core/record-not-found-unauthorized",data:{values:state_utils_1.StateUtils.formatStateValues(c.values)}});throw c.dataInputError({message:"record not found: {{values}}",key:"@sage/xtrem-core/record-not-found",data:{values:JSON.stringify(a)}})}if(d.forEach(e=>{if(!c.interningKeyValues.includes(e))state_intern_1.StateIntern.deleteKey(t,e)}),c.factory.isAbstract)c=StateNew.newConcreteState(t,c,i),state_intern_1.StateIntern.updateInternCache(c);return c.setLazyLoadMarkers(),c}}exports.StateNew=StateNew;
//# sourceMappingURL=state-new.js.map