/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateLoad=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),lodash=require("lodash"),sql_1=require("../sql"),lazy_loaded_marker_1=require("./lazy-loaded-marker"),node_state_1=require("./node-state"),state_intern_1=require("./state-intern"),state_utils_1=require("./state-utils");class StateLoad{static async readFromDatabase(e,t){const a=await e.context.prefetcher.tryRead(e.factory,t,e.forUpdate);if(void 0!==a)return a;const r=await(await e.factory.createNodeQuery(e.context,{filter:t,forUpdate:e.forUpdate,singleResultRequest:true,omitNodeProvidesFilter:true})).getNodeData();if(r)e.context.prefetcher.addRecord(e.factory,e.forUpdate,r);return r}static getKeyFilter(e){if(e.values._id&&Number.isFinite(Number(e.values._id))&&Number(e.values._id)>0||"string"==typeof e.values._id)return"sql"===e.factory.storage?e.factory.parseNodeId(e.values._id):{_id:e.values._id};return Object.keys(e.values).forEach(t=>{if("_constructor"===t)return;const a=e.factory.findProperty(t);if(!(a.isStored||a.getValue))throw new xtrem_shared_1.DataInputError(`${a.fullName}: invalid key property`)}),lodash.omit(e.values,"_id")}static loadFromFunnel(e){if(!e.isThunk)return e.status!==node_state_1.StateStatus.stale;const t=StateLoad.getKeyFilter(e);if(Object.values(t).every(e=>void 0===e))return state_intern_1.StateIntern.removeState(e),e.status=node_state_1.StateStatus.stale,false;const a=e.interningKeyValues[0];return e.context.withReadFunnel(a,async()=>{if(!e.isThunk)return e.status!==node_state_1.StateStatus.stale;const a=await e.factory.getAccessRightsFilter(e.context,true),r=[t];if(a)r.push(a);let s=await e.factory.cache.fetch(e.context,{getKey:()=>JSON.stringify({filters:r,context:e.context.getSqlCacheKey()}),getValue:async()=>({value:await this.readFromDatabase(e,t),storedEncryptedProperties:e.factory.storedEncryptedProperties}),isolateInContext:e.forUpdate,ignoreCache:e.forUpdate});if(!s&&a){const a=await(await sql_1.SqlQuery.create(e.context,e.factory,{filters:[t],forUpdate:false,singleResultRequest:true})).getNodeData();if(a)return e.factory.naturalKey?.forEach(t=>{if(e.values[t]!==a[t])e.values[t]=a[t]}),state_intern_1.StateIntern.removeState(e),e.status=node_state_1.StateStatus.unauthorized,false}if(s&&e.context.isTransient)s={...s};if(e.isThunk=false,!s)return state_intern_1.StateIntern.removeState(e),e.status=node_state_1.StateStatus.stale,false;if(e.values=s,e.setLazyLoadMarkers(),!e.factory.isAbstract)state_intern_1.StateIntern.updateInternCache(e);return true})}static tryLoad(e){if("sql"!==e.factory.storage&&"external"!==e.factory.storage)throw e.systemError(`cannot load: bad class storage: ${String(e.factory.storage)}`);if(!e.isThunk)return e.status!==node_state_1.StateStatus.stale;return StateLoad.loadFromFunnel(e)}static async load(e){if(!await this.tryLoad(e)){if(e.status===node_state_1.StateStatus.unauthorized)throw e.authorizationError({message:"Unauthorized: {{values}}",key:"@sage/xtrem-core/record-not-found-unauthorized",data:{values:state_utils_1.StateUtils.formatStateValues(e.values)}});throw e.dataInputError({message:"record not found: {{values}}",key:"@sage/xtrem-core/record-not-found",data:{values:JSON.stringify(e.values)}})}}static async resolveLazyLoadedValue(e,t){if(e.values[t.name]!==lazy_loaded_marker_1.lazyLoadedMarker)return e.values[t.name];const a=`${e.interningKeyValues[0]}:${t.name}`,r=await e.context.withReadFunnel(a,()=>StateLoad._resolveLazyLoadedValueFromFunnel(e,t));if(null==r)throw new Error(`Lazy-loading of ${e.factory.name}[${e.id}].${t.name} failed, state=${e.status}`);return e.values[t.name]=r[t.name],r[t.name]}static async resolveLazyLoadedValues(e){if(e.factory.lazyLoadedProperties.length>0)await(0,xtrem_async_helper_1.asyncArray)(e.factory.lazyLoadedProperties).forEach(async t=>{await StateLoad.resolveLazyLoadedValue(e,t)})}static async _resolveLazyLoadedValueFromFunnel(e,t){return(await e.factory.createLazyLoadedValueQuery(e.context,e.id,[t])).getNodeData()}}exports.StateLoad=StateLoad;
//# sourceMappingURL=state-load.js.map