/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateIntern=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),_=require("lodash"),state_get_value_1=require("./state-get-value");class StateIntern{constructor(t){this.context=t}addState(t,e,r){if("sql"!==e.factory.storage&&"external"!==e.factory.storage)return;let a;if(e.isTransient)a=this.context.transaction.transientNodeStates;else a=r?this.context.transaction.writableNodeStates:this.context.transaction.readonlyNodeStates;a[t]=e}flushState(t){t.interningKeyValues.forEach(e=>{if(delete this.context.transaction.writableNodeStates[e],"external"!==t.factory.storage)this.context.transaction.readonlyNodeStates[e]=t})}static deleteKey(t,e){delete t.transaction.transientNodeStates[e],delete t.transaction.writableNodeStates[e],delete t.transaction.readonlyNodeStates[e]}static collectKeys(t,e){t.interningKeyValues.forEach(t=>{e.add(t)})}static async removeMutablePropertyStates(t,e){await(0,xtrem_async_helper_1.asyncArray)(t.factory.strictMutableProperties).forEach(async r=>{if(r.isReferenceProperty()){const a=t.references.get(r.name);if(a)this.collectKeys(a.$.state,e)}if(r.isCollectionProperty()){const a=t.collections.get(r.name);if(a)await a.forEach(t=>{this.collectKeys(t.$.state,e)})}})}static async removeStateWithVitalChildren(t){const e=t.factory.extendedVitalFactories.map(t=>t.rootFactory.name),deleteKeys=async r=>{const a=new Set,willBeDeleted=async e=>{if(e===t)return true;if(!e.factory.isVitalChild)return false;const r=e.factory.vitalParentProperty,a=await state_get_value_1.StateGetValue.getReferenceValue(e,r);if(!a){if(e.isTransient)return false;throw new xtrem_shared_1.LogicError("Expecting a valid parent reference for non transient node!")}return willBeDeleted(a.$.state)};await(0,xtrem_async_helper_1.asyncArray)(Object.keys(r).filter(t=>e.some(e=>t.startsWith(e)))).forEach(async t=>{const e=r[t];if(await willBeDeleted(e))this.collectKeys(e,a),await this.removeMutablePropertyStates(e,a)}),a.forEach(t=>{delete r[t]})};if(e.length>0)await deleteKeys(t.context.transaction.transientNodeStates),await deleteKeys(t.context.transaction.writableNodeStates),await deleteKeys(t.context.transaction.readonlyNodeStates);this.removeState(t)}static removeState(t){t.interningKeyValues.forEach(e=>{this.deleteKey(t.context,e)})}getState(t,e){let r=this.context.transaction.writableNodeStates[t];if(!r&&!e)r=this.context.transaction.readonlyNodeStates[t];if(!r)if(r=this.context.transaction.transientNodeStates[t],r&&!r.isTransient)delete this.context.transaction.transientNodeStates[t],r=void 0;return r}static findState(t,e){const r=[...t.interningKeyValues];if(0===r.length)throw new xtrem_shared_1.LogicError(`${t.factory.name}: no interning keys found.`);for(let a=0;a<r.length;a+=1){const n=r[a],s=t.context.intern.getState(n,e);if(s)return s}return}static async removeStateWithData(t,e,r){const deleteStates=async t=>{const a=Object.keys(t).filter(t=>t.startsWith(e.rootFactory.name)).map(e=>t[e]);if(0===Object.keys(r).length)await(0,xtrem_async_helper_1.asyncArray)(a).forEach(t=>this.removeStateWithVitalChildren(t));else await(0,xtrem_async_helper_1.asyncArray)(a.filter(t=>{const e=_.pick(t.values,Object.keys(r));return Object.keys(r).map(t=>r[t]===e[t]).every(t=>t)})).forEach(t=>this.removeStateWithVitalChildren(t))};await deleteStates(t.transaction.transientNodeStates),await deleteStates(t.transaction.writableNodeStates),await deleteStates(t.transaction.readonlyNodeStates)}static canBeInterned(t){if(t.isOnlyForLookup)return false;if(t.isTransient&&"number"==typeof t.values._id&&t.values._id>0)return false;if(!t.factory.keyProperties)return false;return t.interningKeyValues.length>0}static updatePropertyInterningKeys(t,e){if(!t.oldState)return;if(0===this.getPropertyUniqueKeys(t,e).length)return;const r=this.getPropertyInterningKeys(t.oldState,e);Object.values(r).forEach(e=>{this.deleteKey(t.context,e)});const a=t.isWritable,n=this.getPropertyInterningKeys(t,e);Object.values(n).forEach(e=>{t.context.intern.addState(e,t,a)})}static updateInternCache(t){if(!StateIntern.canBeInterned(t))return;const e=t.isWritable;t.interningKeyValues.forEach(r=>{t.context.intern.addState(r,t,e)})}static intern(t,e){if(!StateIntern.canBeInterned(t))return t;const r=t.isWritable,a=this.findState(t,r);if(a){if(t.factory.isContentAddressable)return a;if(e?.forCreate&&!a.isTransient)throw new xtrem_shared_1.LogicError(`No cached state is expected for ${a.factory.name} key: ${a.keyToken} [${a.interningKeyValues}]`);if(!(e?.forCreate&&a.isTransient))return a}return t.interningKeyValues.forEach(e=>{t.context.intern.addState(e,t,r)}),t}static getInterningKeysFromValues(t,e){return t.uniqueKeyProperties.filter(t=>t.every(t=>null!=e[t])).reduce((r,a)=>(r[a.join()]=`${t.rootFactory.name}:${a.map(r=>{let a=r;if("_constructor"===r&&!t.isAbstract)return`${a}:${t.name}`;const n=t.findProperty(r);if(n.factory.name!==t.rootFactory.name&&"_id"!==r)a=`${n.factory.name}.${r}`;return`${a}:${e[r]}`}).join()}`,r),{})}static getInterningKeys(t){const e="external"===t.factory.storage&&null==t.values._id?{...t.values,_id:t.node._id}:t.values;return this.getInterningKeysFromValues(t.factory,e)}static getPropertyUniqueKeys(t,e){return t.factory.uniqueKeyProperties.filter(t=>t.includes(e.name))}static getPropertyInterningKeys(t,e){const r=this.getPropertyUniqueKeys(t,e).map(t=>t.join());return _.pick(t.interningKeys,r)}}exports.StateIntern=StateIntern;
//# sourceMappingURL=state-intern.js.map