/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateInit=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),loggers_1=require("../runtime/loggers"),node_state_1=require("./node-state"),state_dependency_1=require("./state-dependency"),state_get_value_1=require("./state-get-value"),state_intern_1=require("./state-intern"),state_set_value_1=require("./state-set-value"),state_update_1=require("./state-update"),state_utils_1=require("./state-utils");class StateInit{static queueDeferredDefaultValue(e,t){if(e.isTransient||e.isOnlyForDefaultValues||e.isOnlyForDuplicate||e.isOnlyForLookup)return;e.deferredProperties[t.name]=true;const a=t.deferredDefaultValue;e.context.transaction.queueDeferredAction(async()=>{const r="function"==typeof a?await t.executeRule(e,"deferredDefaultValue"):a;await state_update_1.StateUpdate.atomicUpdate(e,{[t.name]:r}),delete e.deferredProperties[t.name]})}static async getSingleReferenceDefaultValue(e,t){const a=await e.context.lookup({node:e.node,property:t},{first:2}).toArray();return 1===a.length?a[0]:null}static getDefaultValue(e,t){return state_dependency_1.StateDependency.withDependenciesRestriction(e,t,async()=>{try{const a=t.defaultValue;if(void 0!==a&&await state_utils_1.StateUtils.isEnabledByServiceOptions(e,t)){if("function"==typeof a){if(!t.isLocalized)return await e.context.withoutLocalizedTextAsJson(()=>e.context.withReadonlyScope(()=>t.executeRule(e,"defaultValue")));return await e.context.withReadonlyScope(()=>t.executeRule(e,"defaultValue"))}return t.defaultValue}if(t.dataType){const a=await e.context.withReadonlyScope(()=>t.dataType?.defaultValue(e.node));if(void 0!==a)return a}if(t.isReferenceProperty()&&!t.isNullable){if(t.isMutable)return{};if(t.targetFactory.defaultsToSingleMatch&&e.isOnlyForDefaultValues)return await this.getSingleReferenceDefaultValue(e,t)}}catch(a){if(e.isOnlyForDefaultValues||e.isOnlyForLookup||e.isOnlyForDuplicate)return loggers_1.loggers.runtime.warn(`failed to get default value of ${t.fullName} during ${e.isOnlyForDefaultValues?"default":"lookup"} query: ${a.message}`),state_get_value_1.StateGetValue.getPlaceholderValue(t);throw loggers_1.loggers.runtime.error(a.stack),a}return})}static async initProperty(e,t,a,r){await state_utils_1.StateUtils.withValidationErrorRethrow(e,t,a,async()=>{if("_id"===t.name)return;if(t.isAutoIncrement&&r)throw e.propertyDataInputError(t,{message:"a value is provided for an auto-increment property",key:"@sage/xtrem-core/value-provided-auto-increment"});if(state_utils_1.StateUtils.isPropertyGetterOnly(t))return;await state_dependency_1.StateDependency.withDependenciesRestriction(e,t,async()=>{let i=void 0===r||!t.isNullable&&null===r;if(t.deferredDefaultValue){if(""===r)i=true;if(e.isTransient)i=false}const s=i?await StateInit.getDefaultValue(e,t):r;if(await state_set_value_1.StateSetValue.setPropertyValue(e,t,a,s),i&&void 0!==t.deferredDefaultValue)if(!t.isLocalized)await e.context.withoutLocalizedTextAsJson(()=>this.queueDeferredDefaultValue(e,t));else this.queueDeferredDefaultValue(e,t)})})}static async init(e,t,a){const r=state_utils_1.StateUtils.restructureDelegatedInputValues(e.factory,a),i=[...e.factory.properties,...Object.values(e.factory.publishedSystemProperties)];await(0,xtrem_async_helper_1.asyncArray)(i).forEach(a=>StateInit.initProperty(e,a,[...t,a.name],r[a.name]))}static cannotCreateAbstractNode(e){return new xtrem_shared_1.LogicError(`Could not create an instance of '${e.name}', this node is declared as abstract`)}static async newFromContextCreate(e,t,a,r,i){if(t.isAbstract){if("string"==typeof r._constructor){const s=e.application.getFactoryByName(r._constructor);if(s.isAbstract)throw this.cannotCreateAbstractNode(s);if(!s.isSubNodeOf(t.name))throw s.logicError(`factory ${s.name} is not a sub-node of ${t.name}`);return StateInit.newFromContextCreate(e,s,a,r,i)}throw this.cannotCreateAbstractNode(t)}if(!(i?.isTransient||i?.isOnlyForDefaultValues||i?.isOnlyForLookup||i?.isOnlyForDuplicate))t.checkCanCreate(e);e.prefetcher.visit(t,false,r);const s=t.getKeyValues(e,r,{allocateTransient:true,isTransient:i?.isTransient,isOnlyForDefaultValues:i?.isOnlyForDefaultValues,isOnlyForDuplicate:i?.isOnlyForDuplicate,isOnlyForLookup:i?.isOnlyForLookup,collection:i?.collection});let n=new node_state_1.NodeState(e,t,s,node_state_1.StateStatus.constructed,{isTransient:i?.isTransient,isOnlyForDefaultValues:i?.isOnlyForDefaultValues,isOnlyForDuplicate:i?.isOnlyForDuplicate,duplicates:i?.duplicates,isOnlyForLookup:i?.isOnlyForLookup,collection:i?.collection});if(n=state_intern_1.StateIntern.intern(n,{forCreate:true}),await StateInit.init(n,a,r),n.status!==node_state_1.StateStatus.constructed&&!t.isContentAddressable)throw n.logicError(`invalid node status at the end of create: ${n.status}`);if(n.status=node_state_1.StateStatus.created,n.factory.events.createEnd&&!n.isOnlyForDefaultValues&&!n.isOnlyForLookup&&!n.isOnlyForDuplicate)await n.factory.executeRule(n,"createEnd");return n}}exports.StateInit=StateInit;
//# sourceMappingURL=state-init.js.map