/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateGetValue=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),__1=require(".."),collections_1=require("../collections"),loggers_1=require("../runtime/loggers"),lazy_loaded_marker_1=require("./lazy-loaded-marker"),node_state_1=require("./node-state"),state_intern_1=require("./state-intern"),state_invalidate_1=require("./state-invalidate"),state_join_1=require("./state-join"),state_load_1=require("./state-load"),state_new_1=require("./state-new"),state_old_1=require("./state-old"),state_utils_1=require("./state-utils");class StateGetValue{static async getScalarValue(e,t){let a=e.values[t.name];if(void 0===a&&e.isThunk)await state_load_1.StateLoad.load(e),a=e.values[t.name];if(a===lazy_loaded_marker_1.lazyLoadedMarker)a=await state_load_1.StateLoad.resolveLazyLoadedValue(e,t);if(void 0===a)return t.getTypeDefaultValue();if(t.isStringProperty()&&t.isLocalized){if(null===a)return"";if(a.startsWith("{")&&a.endsWith("}")&&!e.context.processLocalizedTextAsJson&&"sql"===e.factory.storage){const t=[...e.context.locales,"base"],r=JSON.parse(a),n=t.find(e=>r[e]);if(!n)return a;return r[n]}}return a}static isReferenceWritable(e,t){return t.isMutable&&e.isWritable}static getReferenceFromStateCache(e,t){const a=StateGetValue.isReferenceWritable(e,t),r=e.references.get(t.name);if(r){const n=state_intern_1.StateIntern.findState(r.$.state,a);if(n)return e.references.set(t.name,n.node),n.node}return r}static async getReferenceValue(e,t){const a=e.references,r=t.name,n=StateGetValue.isReferenceWritable(e,t);if(a.has(r))return this.getReferenceFromStateCache(e,t);if(t.isVital&&!e.canBeFetched())return null;if(t.reverseReference||e.factory.externalStorageManager?.isReverseReferenceProperty(t.name)){const l=await state_join_1.StateJoin.getJoinValues(e,t);if((e.isOnlyForDefaultValues||e.isOnlyForLookup)&&0===Object.keys(l).filter(e=>void 0!==l[e]).length)return a.set(r,null),null;const o=await e.context.tryRead(t.targetFactory.nodeConstructor,l,{forUpdate:n?e.forUpdate:false,isTransient:e.isTransient,isOnlyForLookup:e.isOnlyForLookup});return a.set(r,o),o}const l=await StateGetValue.getScalarValue(e,t);if(!l)return a.set(r,null),null;if("external"===e.factory.storage&&e.factory.keyProperties.map(e=>e.name).includes(t.name))if((e.isOnlyForDefaultValues||e.isOnlyForDuplicate||e.isOnlyForLookup)&&e.factory.externalStorageManager?.isKeyPropertyTransient(t.name,l))return a.set(r,null),null;const o=(await state_new_1.StateNew.newReferenceThunk(e,t.targetFactory,t,await state_join_1.StateJoin.getJoinValues(e,t),n)).node;return a.set(r,o),o}static getReferenceArrayFromStateCache(e,t){const a=StateGetValue.isReferenceWritable(e,t),r=e.referenceArrays.get(t.name);if(null==r)return r;const n=r.map(e=>{const t=state_intern_1.StateIntern.findState(e.$.state,a);return t?.node||e});return e.referenceArrays.set(t.name,n),n}static async getReferenceArrayValue(e,t){const a=e.referenceArrays,r=t.name;if(a.has(r))return this.getReferenceArrayFromStateCache(e,t);const n=await StateGetValue.getScalarValue(e,t);if(!n)return a.set(r,null),null;const l=await(0,xtrem_async_helper_1.asyncArray)(n).map(async(a,r)=>(await state_new_1.StateNew.newReferenceThunk(e,t.targetFactory,t,await state_join_1.StateJoin.getArrayJoinValues(e,t,r),false)).node).toArray();return a.set(r,l),l}static createCollection(e,t){return(t.isTransientInput||t.isMutable)&&!e.isOld?new collections_1.MutableCollection(e.node,t):new collections_1.ImmutableCollection(e.node,t)}static getCollectionValue(e,t){const a=t.name;let r=e.collections.get(a);if(!r||!r.isValid())r=this.createCollection(e,t),e.collections.set(a,r);return r}static getPlaceholderValue(e){return e.isCollectionProperty()?[]:null}static async getComputedValue(e,t,a){let r=null;const fetchValue=()=>!t.isLocalized?e.context.withoutLocalizedTextAsJson(()=>e.context.withReadonlyScope(()=>t.executeRule(e,a))):e.context.withReadonlyScope(()=>t.executeRule(e,a));try{if(t.cacheComputedValue){if(e.status!==node_state_1.StateStatus.readonly)await state_invalidate_1.StateInvalidate.validatePropertyValue(e,t,[t.name]);const a=e.keyToken,n=t.fullName,l=e.context.cache.fetchValue(n,a);if(!l)r=await fetchValue(),e.context.cache.storeValue(n,a,{value:r},{category:n,key:a,getValue:()=>({value:r}),ttlInSeconds:3600});else r=l}else r=await fetchValue()}catch(n){if(e.isOnlyForDefaultValues||e.isOnlyForLookup||e.isOnlyForDuplicate)loggers_1.loggers.runtime.warn(`failed to ${a} of ${t.fullName} during ${e.isOnlyForDefaultValues?"default":"lookup"} query: ${n.message}`),r=this.getPlaceholderValue(t);else throw loggers_1.loggers.runtime.error(n.stack),n}return r}static callGetValue(e,t){if("function"!=typeof t.getValue)throw e.propertySystemError(t,"getValue is not callable.");return this.getComputedValue(e,t,"getValue")}static callComputeValue(e,t){if("function"!=typeof t.computeValue)throw e.propertySystemError(t,"computeValue is not callable.");return this.getComputedValue(e,t,"computeValue")}static async getJoinReferenceValue(e,t){if(!t.decorator.join)throw t.logicError("no join");const a=await state_join_1.StateJoin.getJoinValues(e,t);if(t.isNullable)return e.context.tryRead(t.targetFactory.nodeConstructor,a);return e.context.read(t.targetFactory.nodeConstructor,a)}static async getDelegatedValue(e,t){const{reference:a,childProperty:r}=t.getDelegatingInfo(),n=await e.getPropertyValue(a);return n?n.$.getValue(r.name):null}static async dispatchGetPropertyValue(e,t){if(t.delegatesTo)return StateGetValue.getDelegatedValue(e,t);if(t.getValue)return StateGetValue.callGetValue(e,t);if(t.computeValue)return StateGetValue.callComputeValue(e,t);if(t.isReferenceProperty()&&t.decorator.join)return StateGetValue.getJoinReferenceValue(e,t);if(__1.StateDependency.checkDependencyLimit(e,t),e.status!==node_state_1.StateStatus.readonly)await state_invalidate_1.StateInvalidate.validatePropertyValue(e,t,[t.name]);if(t.isReferenceProperty())return state_old_1.StateOld.mapNodeIfOld(e,t,await StateGetValue.getReferenceValue(e,t));if(t.isReferenceArrayProperty())return StateGetValue.getReferenceArrayValue(e,t);if(t.isCollectionProperty())return StateGetValue.getCollectionValue(e,t)||null;return StateGetValue.getScalarValue(e,t)}static getInactiveValue(e,t){if(loggers_1.loggers.core.verbose(()=>`Getting value of inactive property ${t.factory.name}.${t.name} depending on service options [${t.serviceOptions.map(e=>e.name)}]`),t.isNullable)return null;switch(t.type){case"boolean":case"string":case"textStream":case"binaryStream":case"collection":return t.getTypeDefaultValue()}throw e.propertySystemError(t,"cannot get the value of an inactive property")}static checkDeferredProperty(e,t){if(e.isPropertyValueDeferred(t))throw e.propertySystemError(t,"Cannot read property as its default value may be deferred and not yet set. Do not read this property or call context.flushDeferredActions()")}static async getPropertyValue(e,t){if(await e.context.keepEventLoopHealthy(),"collection"===t.type||"_id"===t.name)return this.getPropertyValueSync(e,t);try{if(state_utils_1.StateUtils.checkNotStale(e),!await state_utils_1.StateUtils.isEnabledByServiceOptions(e,t))return StateGetValue.getInactiveValue(e,t);if(t.deferredDefaultValue)this.checkDeferredProperty(e,t);const a=await StateGetValue.dispatchGetPropertyValue(e,t);if(!(null!=a||t.isNullable||e.isTransient||e.isOnlyForLookup||e.isOnlyForDuplicate)){if(void 0!==t.decorator.defaultValue&&e.isOnlyForDefaultValues)return a;throw state_utils_1.StateUtils.requiredPropertyError(e,t)}return a}catch(a){if(e.isOnlyForDefaultValues||e.isOnlyForLookup||e.isOnlyForDuplicate)return null;if(!e.context.disableGetPropertyValueErrorLogger)loggers_1.loggers.runtime.error(`${e.factory.name}.${t.name}: error getting property value: ${a.message}`);throw a}}static getPropertyValueSync(e,t){try{if(state_utils_1.StateUtils.checkNotStale(e),__1.StateDependency.checkDependencyLimit(e,t),"_id"===t.name){if(e.values._id)return e.values._id;return"external"===e.factory.storage?e.factory.externalStorageManager?.getId(e.context,e.values):null}if(t.isCollectionProperty())return this.getCollectionValue(e,t);throw t.systemError("cannot read property value synchronously")}catch(a){if(!e.context.disableGetPropertyValueErrorLogger)loggers_1.loggers.runtime.error(`${e.factory.name}.${t.name}: error getting property value: ${a.message}`);throw a}}static getNaturalKeyValue(e){if(!e.factory.naturalKey)throw e.factory.logicError("no natural key");return(0,xtrem_async_helper_1.asyncArray)(e.factory.naturalKey).map(async t=>{const a=e.factory.findProperty(t),r=await e.getPropertyValue(a);if(a.isReferenceProperty()){const e=r;return e?this.getNaturalKeyValue(e.$.state):""}return r}).join("|")}}exports.StateGetValue=StateGetValue;
//# sourceMappingURL=state-get-value.js.map