/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateDuplicate=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),_=require("lodash"),decorators_1=require("../decorators"),state_dependency_1=require("./state-dependency"),state_init_1=require("./state-init");class StateDuplicate{static convertVitalData(e,t,a,r=false){if(!t)return;if(e.isContentAddressable&&t._id)delete t._id;if(t._id){const r=-Math.abs(Number(t._id));a.set(`${e.name}~${t._id}`,r),t._id=r}const i=e.properties.filter(e=>e.isForeignNodeProperty()&&!e.isSystemProperty&&Object.keys(t).includes(e.name));if(e.hasVendorProperty&&null!=t._vendor)delete t._vendor;if(null!=t._sourceId)delete t._sourceId;i.forEach(e=>{if(e.isMutable){if(e.isCollectionProperty())t[e.name].forEach(t=>{StateDuplicate.convertVitalData(e.targetFactory,t,a,true)});if(e.isReferenceProperty())StateDuplicate.convertVitalData(e.targetFactory,t[e.name],a,true)}else if(e.isVitalParent&&!e.isAssociationParent)if(!r)delete t._sortValue})}static convertNonVitalReferenceData(e,t,a){if(!t)return;e.properties.filter(e=>e.isForeignNodeProperty()&&Object.keys(t).includes(e.name)).forEach(e=>{if(e.isMutable){if(e.isCollectionProperty())t[e.name].forEach(t=>{StateDuplicate.convertNonVitalReferenceData(e.targetFactory,t,a)});if(e.isReferenceProperty())StateDuplicate.convertNonVitalReferenceData(e.targetFactory,t[e.name],a)}else if(t[e.name]&&e.isReferenceProperty()&&a.has(`${e.targetFactory.name}~${t[e.name]?._id}`))t[e.name]=a.get(`${e.targetFactory.name}~${t[e.name]?._id}`);else if(t[e.name]&&Array.isArray(t[e.name])&&e.isReferenceArrayProperty())t[e.name]=t[e.name].map(t=>{const r=`${e.targetFactory.name}~${t._id}`;if(a.has(r))return a.get(r);return t})})}static async getForeignNodePropertyDuplicatedValue(e,t,a,r,i){if(t.isCollectionProperty()&&Array.isArray(a)){const n=await e.getPropertyValue(t);return(0,xtrem_async_helper_1.asyncArray)(a).map(async(e,t)=>{const a=await n.at(t);if(!a)throw new Error(`${r.join(".")}: collection value not found at index ${t}`);return this.setDuplicatedValuesInData(a.$.state,e,r,i)}).toArray()}if(t.isReferenceProperty()){const n=await e.getPropertyValue(t);if(null==n)return;return this.setDuplicatedValuesInData(n.$.state,a,r,i)}return}static async getPropertyDuplicatedValue(e,t,a){let r=t.duplicatedValue;if(void 0!==r){if("function"==typeof r)r=await state_dependency_1.StateDependency.withDependenciesRestriction(e,t,()=>e.context.withReadonlyScope(()=>t.executeRule(e,"duplicatedValue")));if(r===decorators_1.useDefaultValue)if(void 0!==t.deferredDefaultValue){if(r=await state_init_1.StateInit.getDefaultValue(e,t),void 0!==a&&!a.includes(t.name))a.push(t.name)}else r=await state_init_1.StateInit.getDefaultValue(e,t);else if(null===r)r=t.getTypeDefaultValue();return await e.setPropertyValue(t,r),r}if(t.isStringProperty()&&t.isStoredEncrypted){const a=state_init_1.StateInit.getDefaultValue(e,t);return await e.setPropertyValue(t,a),a}return}static async setDuplicatedValuesInData(e,t,a,r){const i={...t};return await(0,xtrem_async_helper_1.asyncArray)(e.factory.properties).forEach(async t=>{const n=i[t.name],s=t.name,o=null==a?[s]:[...a,s];if(t.isForeignNodeProperty()&&t.isMutable&&void 0===t.duplicatedValue){if(null!=n){const a=await this.getForeignNodePropertyDuplicatedValue(e,t,n,o,r);if(void 0!==a)i[s]=a}}else{const a=await this.getPropertyDuplicatedValue(e,t,r);if(void 0!==a)i[s]=a}}),i}static async duplicateState(e,t,a){const r=await e.payload(t),i=new Map;if(StateDuplicate.convertVitalData(e.factory,r,i),StateDuplicate.convertNonVitalReferenceData(e.factory,r,i),!e.node.$.factory.duplicateAttachments)r._attachments=[];const n=await e.context.create(e.factory.nodeConstructor,r,{isOnlyForDuplicate:true,isTransient:true}),s=[],o=await this.setDuplicatedValuesInData(n.$.state,r,void 0,s);if(a?.isTransient){if(a.data)await n.$.set(a.data);return n.$.state}const c=a?.data?_.merge(o,a.data):o,l=await e.context.create(e.factory.nodeConstructor,c,{duplicates:n});return s.forEach(t=>{state_init_1.StateInit.queueDeferredDefaultValue(l.$.state,e.factory.findProperty(t))}),l.$.state}static duplicate(e,t){return this.duplicateState(e,{withIds:true},{data:t})}static getDuplicate(e,t){return this.duplicateState(e,{withIds:true,limitCollections:t?.limitCollections},{isTransient:true})}}exports.StateDuplicate=StateDuplicate;
//# sourceMappingURL=state-duplicate.js.map