/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateDelete=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),_=require("lodash"),nanoid_1=require("nanoid"),collections_1=require("../collections"),decorator_utils_1=require("../decorators/decorator-utils"),validation_error_1=require("../errors/validation-error"),loggers_1=require("../runtime/loggers"),ts_api_1=require("../ts-api"),node_state_1=require("./node-state"),state_intern_1=require("./state-intern"),state_load_1=require("./state-load"),state_visit_1=require("./state-visit");class StateDelete{static async deleteFromTable(e){if(e.isThunk&&!e.values._id)await state_load_1.StateLoad.load(e);const t=e.getKeyValues(),a=await e.factory.table.delete(e.context,t);return e.context.prefetcher.afterDelete(e.factory,e.values),a}static visitFilter(e){const t=e.targetFactory.events;return!!(t.controlDelete||t.deleteBegin||t.deleteEnd)}static callControlEvents(e,t,a){return state_visit_1.StateVisit.visitVitalTree(e.factory,{async visit(e,t){if(!e.factory.events.controlDelete)return true;const a=new ts_api_1.ValidationContext(e.context,e.collection?collections_1.MutableCollection.fillPath(t,e.node):t);try{return await e.context.withReadonlyScope(async()=>(await e.factory.executeRule(e,"controlDelete",a,t.length>0),!e.context.hasErrors()))}catch(e){return loggers_1.loggers.runtime.verbose(e.stack),a.addDiagnose(xtrem_shared_1.ValidationSeverity.error,e.message),false}},walk:t},e,a)}static async deleteFromStorage(e,t=[]){if(e.context.transaction.incrementFactoryTick(e.factory),"sql"===e.factory.storage){if(e.status===node_state_1.StateStatus.created)return;await StateDelete.deleteFromTable(e)}else if("external"===e.factory.storage){if(!e.factory.externalStorageManager?.delete)throw e.systemError("externalStorageManager.delete missing");e.status=node_state_1.StateStatus.deleted,await e.factory.externalStorageManager.delete(e.node,new ts_api_1.ValidationContext(e.context,t))}else throw e.systemError(`cannot delete: invalid storage: ${e.factory.storage}`)}static async callDeleteEvents(e,t,a=[]){await state_visit_1.StateVisit.visitVitalTree(e.factory,{async before(e,t){if(e.factory.events.deleteBegin)await e.factory.executeRule(e,"deleteBegin",t.length>0);return true},async after(e,t){if(e.factory.events.deleteEnd)await e.factory.executeRule(e,"deleteEnd",t.length>0);if(_.isEqual(a,t))await StateDelete.deleteFromStorage(e,t);return await state_intern_1.StateIntern.removeStateWithVitalChildren(e),e.status=node_state_1.StateStatus.stale,true},walk:t},e,a)}static checkStatus(e){switch(e.status){case node_state_1.StateStatus.created:case node_state_1.StateStatus.inserted:case node_state_1.StateStatus.modified:case node_state_1.StateStatus.updatable:break;default:throw new xtrem_shared_1.LogicError(`cannot delete ${e.node}: bad status: ${e.status}`)}}static async deleteWithWalker(e,t){StateDelete.checkStatus(e);const a=await state_visit_1.StateVisit.getWalker(e.factory,StateDelete.visitFilter);if(!t?.skipControls){if(e.isThunk&&!e.node._id)await state_load_1.StateLoad.load(e);if(!await StateDelete.callControlEvents(e,a,t?.path))return false}return await StateDelete.callDeleteEvents(e,a,t?.path),true}static broadcastDelete(e,t){t.getVitalTree().forEach(t=>{t.broadcastCrudMessage(e,"delete")})}static async doDelete(e,t){const a=await e.context.withDiagnoses(()=>(e.factory.checkCanDelete(e.context),StateDelete.deleteWithWalker(e,{...t,skipControls:t&&t.skipControls?t.skipControls:false})),`While deleting ${e.factory.name}(${e.keyToken})`);if(this.broadcastDelete(e.context,e.factory),a)await e.factory.cache.invalidate(e.context);return a}static async tryDelete(e,t){const a=`sp_${(0,nanoid_1.nanoid)().replace(/-/g,"_")}`;await e.context.executeSql(`SAVEPOINT ${a}`,[]);try{return await this.delete(e,t),true}catch(t){if(t.innerError?.table&&t.innerError?.constraint)return await e.context.executeSql(`ROLLBACK TO SAVEPOINT ${a}`,[]),false;if(t instanceof validation_error_1.ValidationError)return await e.context.executeSql(`ROLLBACK TO SAVEPOINT ${a}`,[]),false;throw t}finally{await e.context.executeSql(`RELEASE SAVEPOINT ${a}`,[])}}static async isProtectedByVendor(e){if(!e.factory.hasVendorProperty)return false;return!!await e.vendor}static async delete(e,t){if(await this.isProtectedByVendor(e))throw e.context.businessRuleError({key:"@sage/xtrem-core/could-not-delete-blocked-by-vendor-code",message:"The record is protected by a vendor code and cannot be deleted."});await StateDelete.validateDeleteAccessControl(e);let a=false;try{a=await StateDelete.doDelete(e,t)}catch(t){if(!t.innerError)throw t;const a=t.innerError;if(!(a.table&&a.constraint))throw t;const r=e.context.application.getTableByName(a.table),o=r.getForeignKeyByName(a.constraint);if(o&&o.columnNames.length)throw e.context.businessRuleError({key:"@sage/xtrem-core/could-not-delete-blocked-by-property",message:"Could not delete: blocked by property {{factory}}.{{property}}",data:{factory:r.factory.nodeConstructor.name,property:r.factory.properties.find(e=>e.columnName===o.columnNames[o.columnNames.length-1])?.name},innerError:a});throw t}if(!a)throw e.getValidationError("delete")}static async validateDeleteAccessControl(e){const t=new Set;if(e.factory.provides)e.factory.provides.forEach(e=>{if(decorator_utils_1.FILTER_TAGS.includes(e))t.add(e)});if(e.factory.properties.forEach(e=>{if(e.provides)e.provides.forEach(e=>{if(decorator_utils_1.FILTER_TAGS.includes(e))t.add(e)})}),0===t.size)return;for(const a of t){const t=e.context.getAllowedAccessCodes(a);if(void 0===t)continue;if(null===t)throw e.context.businessRuleError({key:"@sage/xtrem-core/no-access",message:`Access not allowed to ${a}.`,data:{accessType:a}});const r=[];if("site"===a&&e.factory.provides?.includes(a))r.push(String(e.values._id));const o=e.factory.properties.filter(e=>e.provides?.includes(a));for(const t of o){const a=await e.getPropertyValue(t);if(a)r.push(String(a))}if(t.length>0){const o=r.filter(e=>!t.includes(e));if(o.length>0)throw e.context.businessRuleError({key:"@sage/xtrem-core/no-access",message:`Access not allowed to ${a}.`,data:{accessType:a,unauthorizedValues:o}})}}}}exports.StateDelete=StateDelete;
//# sourceMappingURL=state-delete.js.map