/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateCursor=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),_=require("lodash"),utils_1=require("../runtime/utils"),util_1=require("../types/util");class StateCursor{static async getJsonPropertyCursorValue(r,e,t){const selectValue=(r,e)=>{if((0,utils_1.isScalar)(e))return e;return Object.keys(r).map(t=>selectValue(r[t],e[t]))},a=t[e.name],s=await r.getPropertyValue(e);return selectValue(a,s)}static async getReferencePropertyCursorValue(r,e,t){const a=t[e.name];if((0,utils_1.isScalar)(a)){const t=r.values[e.name];if(void 0===t)throw r.propertyDataInputError(e,{message:"invalid cursor value: {{value}}",key:"@sage/xtrem-core/invalid-cursor-value",data:{value:t}});return t}const s=await r.getPropertyValue(e);if(!s)return null;return StateCursor.getCursorValues(s.$.state,a)}static getScalarPropertyCursorValue(r,e,t){const a=t[e.name];if((0,utils_1.isCompound)(a))throw r.propertyDataInputError(e,{message:"invalid property type in orderBy {{type}}",key:"@sage/xtrem-core/invalid-property-type-order-by",data:{type:e.type}});return r.getPropertyValue(e)}static getCursorPropertyValue(r,e,t){if(e.isReferenceProperty())return StateCursor.getReferencePropertyCursorValue(r,e,t);if("json"===e.type)return StateCursor.getJsonPropertyCursorValue(r,e,t);return StateCursor.getScalarPropertyCursorValue(r,e,t)}static getCursorValues(r,e){return(0,xtrem_async_helper_1.asyncArray)(Object.keys(e)).map(t=>{if("_constructor"===t&&!r.factory.isAbstract)return r.factory.name;const a=r.factory.findProperty(t,{includeSystemProperties:true});return StateCursor.getCursorPropertyValue(r,a,e)}).toArray()}static async getCursorValue(r,e){const t=JSON.stringify(_.flattenDeep(await StateCursor.getCursorValues(r,e)));return`${t}${(0,util_1.cursorChecksum)(t)}`}}exports.StateCursor=StateCursor;
//# sourceMappingURL=state-cursor.js.map