/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateControl=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),decimalLib=require("@sage/xtrem-decimal"),xtrem_shared_1=require("@sage/xtrem-shared"),collections_1=require("../collections"),array_utils_1=require("../runtime/array-utils"),loggers_1=require("../runtime/loggers"),ts_api_1=require("../ts-api"),types_1=require("../types"),node_state_1=require("./node-state"),state_get_value_1=require("./state-get-value"),state_load_1=require("./state-load"),state_prepare_1=require("./state-prepare"),state_utils_1=require("./state-utils");class StateControl{static async callControl(t,e,r,a,o){const i=new ts_api_1.ValidationContext(t.context,a);if(e){if(e[r])await t.context.withReadonlyScope(()=>e.executeRule(t,r,i,o))}else if(t.factory.events[r])await t.context.withReadonlyScope(()=>t.factory.executeRule(t,r,i,o))}static async controlScalarProperty(t,e,r){if(null==t.values[e.name])if(e.isRequired&&null==e.delegatesTo)throw state_utils_1.StateUtils.requiredPropertyError(t,e);const a=await state_get_value_1.StateGetValue.getPropertyValue(t,e);if(null==a){if(!e.isNullable)throw state_utils_1.StateUtils.requiredPropertyError(t,e);return void await StateControl.callControl(t,e,"control",r,null)}if(e.isStringProperty())if((e.isRequired||e.isNotEmpty)&&(StateControl.isEmptyLocalizedValue(e,a)||""===a))return void t.context.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.error,r,"string cannot be empty");if(e.isArrayProperty())if(e.isRequired&&0===a.length)return void t.context.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.error,r,"array cannot be empty");if(e.isNumberProperty()){if(e.isNotZero&&decimalLib.eq(a,0))return void t.context.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.error,r,"property cannot be equal to 0");if(!e.name.startsWith("_")&&e.isIntegerProperty()&&!(0,types_1.isInt32)(a))t.context.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.error,r,"integer property cannot represent non 32-bit signed integer value")}if(e.dataType){const o=new ts_api_1.ValidationContext(t.context,r),i=e.dataType;if(e.isLocalized&&t.context.processLocalizedTextAsJson&&"string"==typeof a&&a.startsWith("{")&&a.endsWith("}"))try{const e=JSON.parse(a),r=Object.values(e);return void await(0,xtrem_async_helper_1.asyncArray)(r).forEach(async e=>{await i.controlValue(t.node,o,e)})}catch{}await i.controlValue(t.node,o,a)}if(e.control)await StateControl.callControl(t,e,"control",r,a)}static async controlCollectionProperty(t,e,r){if(!e.isMutable)return;await StateControl.callControl(t,e,"controlBegin",r,null);const a=await t.getPropertyValue(e);if(e.isRequired&&0===await a.length)return void t.context.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.error,r,"required data collection cannot be empty");await a.forEach(async a=>{const o=collections_1.MutableCollection.fillPath(r,a);await state_utils_1.StateUtils.withValidationErrorRethrow(t,e,o,async()=>void await StateControl.controlState(a.$.state,o))}),await StateControl.callControl(t,e,"controlEnd",r,null)}static async getIsActiveFilter(t,e){const r=t.getTargetIsActivePropertyName(),a=t.ignoreIsActive;if(!("function"==typeof a?await e.$.state.context.withReadonlyScope(()=>a.call(e)):!!a)&&r)if(e.$.state.status===node_state_1.StateStatus.created||e.$.state.status===node_state_1.StateStatus.modified&&e.$.state.values[t.name]!==(await e.$.old).$.state.values[t.name])return{[r]:true};return}static async controlReferenceFilter(t,e,r,a){const o=t.node,controlFilterItem=async e=>{if(!e.filter)return true;const i=t.context,n=await i.buildFilter(e.filter,o);if(await(0,array_utils_1.matchesFilter)(n,a,i.locales))return true;return i.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.error,r,await e.getErrorMessage.call(t.node)),false},i=await this.getIsActiveFilter(e,o);if(!await controlFilterItem({filter:i,getErrorMessage(){return this.$.context.localize("@sage/xtrem-core/cannot-reference-inactive-record","The record cannot be referenced because it is inactive.")}}))return;const n=e.filters?.control;if(!await controlFilterItem({filter:n,getErrorMessage(){return this.$.context.localize("@sage/xtrem-core/control-filter-not-satisfied","The record is not valid. You need to select a different record.")}}))return;const l=e.filters?.controls;if(l)await(0,xtrem_async_helper_1.asyncArray)(l).every(t=>controlFilterItem(t));state_utils_1.StateUtils.validateAccessControl(t,e,a)}static async controlReferenceProperty(t,e,r){const a=await t.getPropertyValue(e);if(null==a){if(!e.isNullable)throw state_utils_1.StateUtils.requiredPropertyError(t,e);return void await StateControl.callControl(t,e,"control",r,null)}const o=a.$.state;if(o.isThunk)await state_load_1.StateLoad.load(o);if(e.isMutable)await StateControl.controlState(o,r);else await StateControl.controlReferenceFilter(t,e,r,a);await StateControl.callControl(t,e,"control",r,a)}static async controlReferenceArrayProperty(t,e,r){const a=await t.getPropertyValue(e);if(null==a){if(!e.isNullable)throw state_utils_1.StateUtils.requiredPropertyError(t,e);return void await StateControl.callControl(t,e,"control",r,null)}if(e.isRequired&&0===a.length)t.context.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.error,r,"array cannot be empty");await(0,xtrem_async_helper_1.asyncArray)(a).forEach(async(a,o)=>{const i=a.$.state;if(i.isThunk)await state_load_1.StateLoad.load(i);await StateControl.controlReferenceFilter(t,e,[...r,String(o)],a)}),await StateControl.callControl(t,e,"control",r,a)}static async controlProperty(t,e,r){await state_utils_1.StateUtils.withValidationErrorRethrow(t,e,r,async()=>{if(await state_prepare_1.StatePrepare.skipPropertyInPrepareAndControl(t,e))return;if(e.isReferenceProperty())await StateControl.controlReferenceProperty(t,e,r);else if(e.isReferenceArrayProperty())await StateControl.controlReferenceArrayProperty(t,e,r);else if(e.isCollectionProperty())await StateControl.controlCollectionProperty(t,e,r);else await StateControl.controlScalarProperty(t,e,r)})}static async controlState(t,e){if(t.skipSave)return true;return await StateControl.callControl(t,null,"controlBegin",e),await(0,xtrem_async_helper_1.asyncArray)(t.factory.properties).forEach(r=>StateControl.controlProperty(t,r,[...e,r.name])),await StateControl.callControl(t,null,"controlEnd",e),!t.context.diagnoses.some(t=>t.severity>=xtrem_shared_1.ValidationSeverity.error)}static async control(t){try{return await state_prepare_1.StatePrepare.prepareState(t,[])&&await StateControl.controlState(t,[])}catch(e){if("40001"===(0,xtrem_shared_1.unwrapError)(e).code)throw e;return loggers_1.loggers.runtime.error(e.stack),t.context.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.exception,e.path??[],e.message),false}}static isEmptyLocalizedValue(t,e){return t.isLocalized&&("string"==typeof e&&"{}"===e||"object"==typeof e&&!Object.keys(e).length)}}exports.StateControl=StateControl;
//# sourceMappingURL=state-control.js.map