/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.NotificationTopic=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),lodash_1=require("lodash");class NotificationTopic{#i;#t;#e=false;constructor(i){this.options=i}get appName(){return this.options.appName}get name(){if(!this.#i)throw this.logicError("notification topic not registered");return this.#i}get topic(){return this.options.topic}get title(){return this.topic.split("/").map(xtrem_shared_1.titleCase).join(" / ")}get definingPackage(){if(!this.#t)throw this.logicError("notification topic not registered");return this.#t}completeRegistration(i,t){if(!i)throw new xtrem_shared_1.LogicError("cannot registrer notification topic with empty name");if(this.#i||this.#t)throw this.logicError(`notification topic registered twice: in ${this.#t?.name} and in ${t.name}`);this.#i=i,this.#t=t}get application(){return this.definingPackage.application}logicError(i){return new xtrem_shared_1.LogicError(`${this.name}: ${i}`)}verify(){if(this.#e)return;if(this.application.findNotificationTopic(this.name),this.name!==(0,lodash_1.camelCase)(this.topic))throw this.logicError(`Mismatch on name of notification topic. Expected ${(0,lodash_1.camelCase)(this.topic)}, got ${this.name}`);if(this.appName&&!this.topic.startsWith("/"))throw this.logicError("Notification topic with app must have an absolute path (with a leading /)");if(!this.appName&&this.topic.startsWith("/"))throw this.logicError("Notification topic without app must have a relative path (no leading /)");this.#e=true}checkVerified(){if(!this.#e)throw this.logicError("Notification topic was not verified")}}exports.NotificationTopic=NotificationTopic;
//# sourceMappingURL=notification-topic.js.map