import { LogicError } from '@sage/xtrem-shared';
import { Application, Package } from '../application';
/** Options passed to the NotificationTopic constructor. */
export interface NotificationTopicConstructOptions {
    /**
     * The app name. It is only set in inter-app notification topics.
     * It identifies the app which produces the notifications.
     *
     * If the topic is internal to an application (intra-app), app must be empty.
     */
    appName: string;
    /**
     * The notification topic:
     * - /appName/nodeName/eventName if inter-app
     * - nodeName/eventName if intra-app
     */
    topic: string;
}
/**
 * Class for notification topics
 *
 * A NotificationTopic describes a topic which may be listened to by this app or by other apps deployed in the cluster.
 */
export declare class NotificationTopic {
    #private;
    private readonly options;
    /**
     * const myNotificationTopic = new NotificationTopic({ app: myApp, topic: '/myApp/myNode/myEvent' })
     */
    constructor(options: NotificationTopicConstructOptions);
    /**
     * The app which produces the notification.
     *
     * This property must be:
     * - non-null for inter-app notifications
     * - null for intra-app notifications.
     */
    get appName(): string;
    /** The name of the notification topic */
    get name(): string;
    /** The topic */
    get topic(): string;
    /** Friendly title for the topic */
    get title(): string;
    /** The package which defines the notification topic */
    get definingPackage(): Package;
    /** The application object */
    get application(): Application;
    /** Utility to create a LogicError. Prefixes the message with the topic name */
    logicError(message: string): LogicError;
    /** Throws an error if the verify method has not been called. */
    checkVerified(): void;
}
//# sourceMappingURL=notification-topic.d.ts.map