/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.InteropGraphqlClient=exports.logger=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_log_1=require("@sage/xtrem-log"),xtrem_shared_1=require("@sage/xtrem-shared"),axios_1=require("axios"),contentType=require("content-type"),jwt=require("jsonwebtoken"),_=require("lodash"),node_http_1=require("node:http"),core_hooks_1=require("../runtime/core-hooks"),secret_manager_1=require("../runtime/secret-manager"),security_1=require("../security"),log_helper_1=require("../utils/log-helper");function isAggregateError(e){return void 0!==e.errors}function isAxiosError(e){return void 0!==e.isAxiosError}function tryParseJson(e,t={}){try{return JSON.parse(e)}catch{return t}}function logIncomingMessageData(e){let t="";e.on("data",e=>{t+=e}),e.on("end",()=>{exports.logger.verbose(()=>`graphql stream response ${String(t)}`)})}exports.logger=xtrem_log_1.Logger.getLogger(__filename,"interop");class InteropGraphqlClient{static getSignatureKey(e){const t={xtremEnv:process.env.XTREM_ENV,clusterId:xtrem_config_1.ConfigManager.current?.clusterId};return secret_manager_1.SecretManager.getTenantEncryptionKey(t,e)}static async getBearerToken(e){const{tenantId:t,expiresIn:r}=e;if(!t)throw new xtrem_shared_1.LogicError("missing tenantId");const s=await this.getSignatureKey(t);return jwt.sign(e,s,{algorithm:"HS256",expiresIn:r??"2m"})}static async parseBearerToken(e){const t=jwt.decode(e);if(!t)throw new Error("invalid bearer token: cannot decode");if(!t.tenantId)throw new Error("invalid bearer token: missing tenantId");const{tenantId:r}=t,s=await this.getSignatureKey(r),n=jwt.verify(e,s);if(!(n.tenantId&&n.appName&&n.scope&&n.sourceUserEmail))throw new Error("invalid bearer token: missing claims");return n}static getScopeUserEmail(e){return`scope-${e}@localhost.domain`}static getUrl(e,t){const r=xtrem_config_1.ConfigManager.current.apps?.[e]?.[t];if(!r)throw new xtrem_shared_1.LogicError(`${e}: ${t} is not configured`);if("string"!=typeof r)throw new xtrem_shared_1.LogicError(`${e}: ${t} is not a string`);return r}static getAppUrl(e){return InteropGraphqlClient.getUrl(e,"appUrl")}static getInteropUrl(e){return InteropGraphqlClient.getUrl(e,"interopUrl")}static getRequestConfig(e,t={}){return _.merge({headers:e,validateStatus:e=>401===e||e>=200&&e<300,httpsAgent:security_1.TlsHelper.getInteropHttpsAgent()},t)}static async sendAnyGraphqlRequest(e,{appName:t,scope:r,query:s,variables:n={},config:o={}}){const a=`${this.getInteropUrl(t)}${(await core_hooks_1.CoreHooks.interopManager.getInteropAppInfo(e,t)).isConnector?"/proxy":"/api"}`,{tenantId:i,cloudflareRayID:g,originId:p}=e;if(!i)throw new xtrem_shared_1.LogicError("missing tenantId");const c=await core_hooks_1.CoreHooks.interopManager.getTenantApps(i);if(!c||!c.includes(t))throw new Error(`App ${t} is not provisioned for tenant ${i}`);const u=(await e.user)?.email;if(!u)throw new xtrem_shared_1.LogicError("missing sourceUserEmail");const l=(await e.loginUser)?.email,d=await this.getBearerToken({appName:t,tenantId:i,scope:r,sourceUserEmail:u,login:l}),h=InteropGraphqlClient.getRequestConfig({Authorization:`Bearer ${d}`,"accept-language":e.currentLocale,accept:"application/json,multipart/mixed","cf-ray":g,"x-request-id":p},o);exports.logger.debug(()=>`sending graphql query ${s} with ${JSON.stringify(n)}, axiosConfig=${JSON.stringify(h)}`);try{const e=await axios_1.default.post(a,{query:s,variables:n},h);if(401===e.status)throw exports.logger.error(`Authentication error: ${e.status} ${e.statusText} - ${JSON.stringify(e.data||"no data")}`),new Error(`Request failed with status code ${e.status} ${e.statusText}`);if(exports.logger.isActive("debug"))if(e.data instanceof node_http_1.IncomingMessage)logIncomingMessageData(e.data);else exports.logger.debug(()=>`graphql response [${e.data?JSON.stringify(e.data.constructor.name):JSON.stringify(e.data)}] ${String(JSON.stringify(e.data))}`);return e}catch(e){throw InteropGraphqlClient.interopError(t,e)}}static interopError(e,t){let r,s=t.message;if(isAxiosError(t)){if(!s)s=`Request failed with code ${t.code}`;if(t.response){const e=contentType.parse(t.response.headers?.["content-type"]??""),n=t.response.data;s=`${t.response.status} ${t.response.statusText}`,r={status:t.response.status,statusText:t.response.statusText};const o=1e3;if("string"==typeof n){const t=n.length;if(r.body=t>o?`${n.substring(0,o)}[${t-o} more...]`:n,"text/plain"===e.type)s=r.body}else if(Buffer.isBuffer(n)){const e=n.length;r.body=e>o?`${n.subarray(0,o).toString("hex")}[${e-o} more...]`:n.toString("hex")}else if("object"==typeof n)r.body=`[object: ${n?.constructor?.name}]`;if("application/json"===e.type&&!(n instanceof node_http_1.IncomingMessage))r.body=tryParseJson(String(n),r.body)}}const n=[];if(isAggregateError(t)&&Array.isArray(t.errors)){if(!s)s=`Request failed with code ${t.errors[0]?.code??"<unknown>"}`;t.errors.forEach(e=>{n.push({severity:xtrem_shared_1.ValidationSeverity.error,message:e.message,path:[]}),exports.logger.error(e.toString())})}return s=`[${e}] ${s}`,exports.logger.error(`interop error: ${s}, http=${(0,log_helper_1.json5Stringify)(r)}`),new xtrem_shared_1.InteropError(s,n,r,t)}static sendGraphqlRequest(e,t){return this.sendAnyGraphqlRequest(e,t)}static sendStreamGraphqlRequest(e,t){const r=_.merge(t.config,{headers:{"accept-encoding":"identity"}});return this.sendAnyGraphqlRequest(e,{...t,config:r})}static async getAppHealth(e){const t=Date.now();try{const r=InteropGraphqlClient.getRequestConfig({},{validateStatus:()=>true}),s=`${InteropGraphqlClient.getInteropUrl(e)}/ping`,n=await axios_1.default.get(s,r),o=xtrem_date_time_1.Datetime.now(true);return{timestamp:o,duration:o.value-t,status:n.status,statusText:n.statusText,isAlive:200===n.status}}catch(e){const r=xtrem_date_time_1.Datetime.now(true);return{timestamp:r,duration:r.value-t,status:e.response?.status||500,statusText:e.response?.statusText||e.message,isAlive:false}}}}exports.InteropGraphqlClient=InteropGraphqlClient;
//# sourceMappingURL=interop-graphql-client.js.map