/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.interopAuthMiddleware=void 0,exports.interopApp=interopApp;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_shared_1=require("@sage/xtrem-shared"),body_parser_1=require("body-parser"),express=require("express"),jsonwebtoken_1=require("jsonwebtoken"),_=require("lodash"),graphql_1=require("../graphql"),http_1=require("../http"),core_hooks_1=require("../runtime/core-hooks"),security_1=require("../security"),interop_graphql_client_1=require("./interop-graphql-client"),errorMiddleware=(e,r)=>(t,i)=>{i.status(e).send(r)},interopAuthMiddleware=async(e,r,t)=>{const i=security_1.TlsHelper.getPeerCertificate(e);if(i){if(!e.client?.authorized)return interop_graphql_client_1.logger.error("Invalid client certificate: Not authorized."),void r.status(403).send("Invalid client certificate.");if(!i.subjectaltname)return interop_graphql_client_1.logger.error("Invalid client certificate: No Subject Alternative Name."),void r.status(403).send("Invalid client certificate.");const t=i.subjectaltname.split(", ").filter(e=>e.startsWith("DNS:")).map(e=>e.replace("DNS:","")),n=_.uniq(t.map(e=>/^([a-z0-9-]+)-xtrem-service-/.exec(e)?.[1])).map(e=>e?.replace(/-/g,"_")),{apps:o}=xtrem_config_1.ConfigManager.current;if(!o||!n.some(e=>e&&null!=o[e]))return interop_graphql_client_1.logger.error(`Invalid client certificate: No matching app among the DNS names. Expecting one of [${Object.keys(o??{})}] got [${n.join(", ")}]`),void r.status(403).send("Invalid client certificate.")}const n=e.headers.authorization;if(!n)return void r.status(401).send("no Authorization header");const o=/^Bearer\s+(.*)/.exec(n),a=o?.[1];if(!a)return void r.status(401).send("no Bearer token");try{const e=await interop_graphql_client_1.InteropGraphqlClient.parseBearerToken(a),i=Math.floor(Date.now()/1e3);if(e.exp&&e.exp<i)return interop_graphql_client_1.logger.warn(`JWT token expired. Token exp: ${e.exp}, Current time: ${i}`),void r.status(401).send("Token expired");const{tenantId:n,scope:o}=e,s=e.login&&e.sourceUserEmail!==e.login?e.sourceUserEmail:void 0;if(s&&!s.endsWith("@localhost.domain"))return interop_graphql_client_1.logger.warn(`Invalid persona email domain: ${s}`),void r.status(401).send("Invalid persona email domain");const l="sourceUser"===o?e.login??e.sourceUserEmail:interop_graphql_client_1.InteropGraphqlClient.getScopeUserEmail(e.scope);if(r.locals.auth={...e,login:l,persona:s},r.locals.config={tenantId:n},e?.remoteContext)r.locals.remoteContext=e.remoteContext;t()}catch(e){if(e instanceof jsonwebtoken_1.JsonWebTokenError)if(e.message.includes("expired")||e.message.includes("exp"))interop_graphql_client_1.logger.warn(`JWT token expired: ${e.message}`),r.status(401).send("Token expired");else if(e.message.includes("invalid")||e.message.includes("malformed"))interop_graphql_client_1.logger.warn(`Invalid JWT token: ${e.message}`),r.status(401).send("Invalid token");else interop_graphql_client_1.logger.error(`JWT token verification failed: ${e.message}`),r.status(401).send("Token verification failed");else interop_graphql_client_1.logger.error(`Unknown JWT token verification error: ${e.message}`),r.status(401).send("Token verification failed")}};function interopApp(e){const r=xtrem_config_1.ConfigManager.current.interop?.graphqlTimeLimitInSeconds||120;routesConfig.refresh(),xtrem_config_1.ConfigManager.emitter.addListener("loaded",()=>routesConfig.refresh());const t=routesConfig.createDelayHandler(),i=express();return i.use((0,http_1.requestLoggerMiddleware)(interop_graphql_client_1.logger)),i.use(t),i.get("/ping",(e,r)=>{r.json({})}),i.use(exports.interopAuthMiddleware),i.use((0,body_parser_1.json)()),i.use("/proxy",core_hooks_1.CoreHooks.interopManager.interopProxyMiddleware(e)),i.use("/api",(0,graphql_1.graphQlApp)(e,{graphqlTimeLimitInSeconds:r})),i.use(errorMiddleware(404,"not found")),i.use((e,r,t,i)=>{if(interop_graphql_client_1.logger.error(e.stack),e instanceof xtrem_shared_1.BaseError)t.status(200).send({extensions:e.extensions});else i(e)}),i}exports.interopAuthMiddleware=interopAuthMiddleware;const routesConfig=new class{#e;refresh(){interop_graphql_client_1.logger.info("Refreshing interop routes delay configuration");const e=xtrem_config_1.ConfigManager.current.app?xtrem_config_1.ConfigManager.current.apps?.[xtrem_config_1.ConfigManager.current.app]?.interopRoutes??{}:{};this.#e=Object.keys(e).reduce((r,t)=>{const i=e[t].response;if(i&&(i.minDelayMillis||i.maxDelayMillis)){const e=i.minDelayMillis??0,n=i.maxDelayMillis??e;r[t]={minDelayMillis:e,delayWindowSizeMillis:n-e+1}}return r},(0,xtrem_shared_1.createDictionary)())}createDelayHandler(){return(e,r,t)=>{const i=(0,http_1.getRequestId)(e),n=e.originalUrl.split("/",2)[1],o=this.#e[n];if(!o)return interop_graphql_client_1.logger.verbose(()=>`HTTP nodelay  ${i} ${e.method} ${e.originalUrl} `),void t();const{minDelayMillis:a,delayWindowSizeMillis:s}=o,l=Math.floor(Math.random()*s+a);interop_graphql_client_1.logger.info(()=>`HTTP delay    ${i} ${e.method} ${e.originalUrl} (delay response by ${l} ms)`);const p=r.end;r.end=(...e)=>{setTimeout(()=>p.apply(r,e),l)},t()}}};
//# sourceMappingURL=interop-app.js.map