import { AuthConfig } from '@sage/xtrem-shared';
import { Express, NextFunction, Request, Response } from 'express';
import { Application } from '../application';
export interface InteropAppInfo {
    name: string;
    title: string;
    isConnector: boolean;
    interopPackage: string;
    isActive: boolean;
}
export interface InteropAuthConfig extends AuthConfig {
    appName: string;
    scope: string;
    sourceUserEmail: string;
    iat: number;
    exp: number;
    persona?: string;
}
interface RequestWithClientAuth extends Request {
    client?: {
        authorized: boolean;
    };
}
export declare const interopAuthMiddleware: (req: RequestWithClientAuth, res: Response, next: NextFunction) => Promise<void>;
/**
 * Creates an express app that serves the interop API.
 * @param application The application to serve.
 * @returns The express app.
 */
export declare function interopApp(application: Application): Express;
export {};
//# sourceMappingURL=interop-app.d.ts.map