/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.loggerAllowsCompress=loggerAllowsCompress,exports.requestLoggerMiddleware=requestLoggerMiddleware,exports.bodyLoggerMiddleware=bodyLoggerMiddleware;const xtrem_config_1=require("@sage/xtrem-config"),request_1=require("./request");function loggerAllowsCompress(e){return!e.isActive("verbose")}function truncate(e,r=80){const t=r<10?"":` (len=${e.length})`;return e.length>r?`${e.substring(0,r)}...${t}`:e}function getBodyJsonSanitizer(){if("development"===xtrem_config_1.ConfigManager.current.deploymentMode)return(e,r)=>r;return(e,r)=>{if("string"!=typeof r)return r;if("_id"===e)return r;return"..."}}class HttpVerbose{constructor(e){this.service=e}static bodyStringSanitizer(e){try{return JSON.stringify(JSON.parse(e),getBodyJsonSanitizer())}catch{return truncate(e,3)}}logRequestBody(e){if(!e.body)return"";const r=(0,request_1.getRequestId)(e),t=JSON.stringify(e.body,getBodyJsonSanitizer());return`HTTP ${this.service} request  ${r} body: ${truncate(t)}`}logResponse(e,r,t){const s=(0,request_1.getRequestId)(e.req);if("string"==typeof t)return`HTTP ${this.service} response ${s} ${r}: ${t&&truncate(HttpVerbose.bodyStringSanitizer(t).replace(/\n/g,"\\n"))}`;const n=null==t?`${t}`:`0x${t.subarray(0,3).toString("hex")} [length: ${t.length}]`;return`HTTP ${this.service} response ${s} ${r}: ${n}`}}class HttpDebug{constructor(e){this.service=e}logRequestBody(e){if(!e.body)return"";const r=(0,request_1.getRequestId)(e),t=e.body.query?Object.keys(e.body).map(r=>`\n${r}: ${e.body[r]}`):JSON.stringify(e.body,getBodyJsonSanitizer());return`HTTP ${this.service} request  ${r} body: ${t}`}logRequestHeaders(e){const r=(0,request_1.getRequestId)(e);return`HTTP ${this.service} request  ${r} headers: ${JSON.stringify(e.headers)}`}logResponseHeaders(e){const r=(0,request_1.getRequestId)(e.req);return`HTTP ${this.service} response ${r} headers: ${JSON.stringify(e.getHeaders())}`}logResponse(e,r,t){const s=(0,request_1.getRequestId)(e.req);if("string"==typeof t)return`HTTP ${this.service} response ${s} ${r}: ${t}`;let n="";if(null==t)n=`${t}`;else if(t.length<50)n=`0x${t.toString("hex")} [length: ${t.length}]`;else n=`0x${t.subarray(0,50).toString("hex")}...[${t.length-50} more bytes, length: ${t.length}]`;return`HTTP ${this.service} response ${s} ${r}: ${n}`}}function requestLoggerMiddleware(e){let r=0;return(t,s,n)=>{r+=1,(0,request_1.setRequestId)(t,r);const o=performance.now(),i=r,u={cfRay:t.headers["cf-ray"],userAgent:t.headers["user-agent"]};e.info(`HTTP request  ${i} ${t.method} ${t.originalUrl} ${JSON.stringify(u)}`);const g=s.end;return s.end=(...r)=>(e.info(`HTTP response ${i} ${s.statusCode} ${t.method} ${t.originalUrl} ${Math.round(100*(performance.now()-o))/100}ms`),g.apply(s,r)),n()}}function bodyLoggerMiddleware(e){const r=new HttpDebug(""),t=new HttpVerbose("");return(s,n,o)=>{if(!e.isActive("verbose"))return o();if(e.isActive("debug"))e.debug(()=>r.logRequestHeaders(s)),e.debug(()=>r.logRequestBody(s));else e.verbose(()=>t.logRequestBody(s));const i=n.write;n.write=(...s)=>{if(e.isActive("debug"))e.debug(()=>r.logResponse(n,"chunk",s[0]));else e.verbose(()=>t.logResponse(n,"chunk",s[0]));return i.apply(n,s)};const u=n.end;return n.end=(...s)=>{if(e.isActive("debug"))e.debug(()=>r.logResponse(n,"end",s[0])),e.debug(()=>r.logResponseHeaders(n));else e.verbose(()=>t.logResponse(n,"end",s[0]));return u.apply(n,s)},o()}}
//# sourceMappingURL=logger-middleware.js.map