/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.executeBulkAction=void 0,exports.parseFilterForGenericBulkMutation=parseFilterForGenericBulkMutation;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),lodash_1=require("lodash"),error_utils_1=require("../../errors/error-utils"),core_hooks_1=require("../../runtime/core-hooks"),loggers_1=require("../../runtime/loggers"),node_factory_utils_1=require("../../runtime/node-factory-utils"),paging_filter_1=require("../paging/paging-filter"),logger=loggers_1.loggers.graphQl,fetchBulkIds=(e,t,r)=>{if(!r)throw new xtrem_shared_1.DataInputError("Filter is empty");const o=(0,node_factory_utils_1.friendlyJsonParse)(r);if(!(0,lodash_1.isObject)(o))throw new xtrem_shared_1.DataInputError("Parsed filter is not an object");return e.select(t,true,{filter:o})},executeBulkAction=async(e,t,r,{body:o,onComplete:i})=>{let a=Date.now();const s=await fetchBulkIds(e,r,t);let n=0,l=0;const u=e.isWritable,c=i?[]:void 0;if(await(0,xtrem_async_helper_1.asyncArray)(s).some(async t=>{if(Date.now()>a+100)if(a=Date.now(),await core_hooks_1.CoreHooks.communicationManager.isStopRequested(e))return true;try{const executeBody=async e=>{const i=await e.read(r,{_id:t},{forUpdate:u}),a=await o(e,i);if(c)c.push(a)};if(u)await e.withChildContext(executeBody,{isolationLevel:"low",isDetachedContext:true});else await executeBody(e);n+=1}catch(o){e.diagnoses.push((0,lodash_1.omit)((0,error_utils_1.mapErrorToDiagnosis)(e,o),"factoryName")),logger.error(`${r.name} bulk mutation failed with ${t}`),logger.error(o.stack),l+=1}return await core_hooks_1.CoreHooks.communicationManager.updateProgress(e,{successCount:n,errorCount:l,totalCount:s.length}),false}))await core_hooks_1.CoreHooks.communicationManager.setStopped(e,e.getContextValue("notificationId"));if(i&&c)if(u)await e.withChildContext(e=>i(e,c),{isolationLevel:"low",isDetachedContext:true});else await i(e,c);return s.length};function parseFilterForGenericBulkMutation(e,t,r){return paging_filter_1.PagingFilter.parseFilter(e,t,r)}exports.executeBulkAction=executeBulkAction;
//# sourceMappingURL=bulk-utils.js.map