/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.OperationType=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),graphql_1=require("graphql"),lodash_1=require("lodash"),application_1=require("../../application"),operation_error_1=require("../../errors/operation-error"),core_hooks_1=require("../../runtime/core-hooks"),access_rights_1=require("../security/access-rights"),object_type_1=require("./object-type"),property_type_1=require("./property-type");class OperationType{static makeParameter(e){if("string"==typeof e)return{type:e};return e}static makeParameterProperty(e,t,r,a,o){const n="parameter"===o,i="return"===o,s=true,c=OperationType.makeParameter(r),p={...c,name:a,isPublished:s,isInputOnly:n,isOutputOnly:i};if("reference"===c.type||"instance"===c.type)p.targetFactory=e.application.getFactoryByConstructor(c.node());if("object"===c.type)p.targetFactory=OperationType.makeGraphQlFactory(e,t,p,o);if("array"===c.type)p.item=OperationType.makeParameterProperty(e,t,c.item,p.name,"parameter");const u=c.dataType;if(u)p.dataType="function"==typeof u?u():u;return p}static makeGraphQlFactory(e,t,r,a){if("object"!==r.type)throw new Error(`${r.name}: invalid property type: ${r.type}`);const o=r.properties,n=Object.keys(o).map(r=>OperationType.makeParameterProperty(e,t,o[r],r,a)),i=`${t}_${r.name}`;return{name:i,fullName:i,publishedSystemProperties:{},publishedInputSystemProperties:[],properties:n,impactingServiceOptions:[],subFactories:[],naturalKey:[],getNodeSchemaDescription:()=>`${r.name}`}}static combineOperationParameters(e){return{type:"object",name:e.name,properties:e.parameters.reduce((e,t)=>(e[t.name]=t,e),{})}}static async executeAsyncMutationStart(e,t,r,a){return{trackingId:await core_hooks_1.CoreHooks.communicationManager.startAsyncMutation(e,t.name,r,a)}}static async executeAsyncMutationStop(e,t){const{trackingId:r,reason:a}=t;return await core_hooks_1.CoreHooks.communicationManager.requestStop(e,r,a),true}static async executeAsyncMutationRequestUserNotification(e,t){const{trackingId:r}=t;return await core_hooks_1.CoreHooks.communicationManager.requestUserNotification(e,r),true}static executeAsyncMutation(e,t,r,a){switch(r.action){case"start":return this.executeAsyncMutationStart(e,t,r.name,a);case"stop":return this.executeAsyncMutationStop(e,a);case"requestUserNotification":return this.executeAsyncMutationRequestUserNotification(e,a);default:throw new xtrem_shared_1.LogicError(`invalid operation action: ${r.action}`)}}static executeAsyncTrackerQuery(e,t,r,a){return core_hooks_1.CoreHooks.communicationManager.trackAsyncMutation(e,t,r,a)}static getStaticMethod(e,t){const r=e.nodeConstructor[t.name];if(!r)throw new xtrem_shared_1.LogicError(`${e.fullName}.${t.name}: operation not found`);if("function"!=typeof r)throw new xtrem_shared_1.LogicError(`${e.fullName}.${t.name}: operation is not a function`);return r}static async execute(e,t,r,a,o,n,i){const body=async e=>{switch(r.operationKind){case"query":case"mutation":{const o=OperationType.getStaticMethod(t,r),s=await object_type_1.ObjectType.getInputValue(e,a,n,i),c=r.parameters.map(e=>s[e.name]);return o.apply(t.nodeConstructor,[e,...c])}case"asyncTrackerQuery":return OperationType.executeAsyncTrackerQuery(e,t,a.trackingId,r);case"bulkMutation":case"asyncMutation":return OperationType.executeAsyncMutation(e,t,r,a);default:throw new xtrem_shared_1.LogicError(`${t.fullName}.${r.name}: invalid operation kind: ${r.operationKind}`)}},s=r.isolationLevel||"low";if(!o&&"low"===s)return body(e);if(o&&r.startsReadOnly&&!["bulkMutation","asyncMutation"].includes(r.operationKind)){if("function"==typeof r.startsReadOnly?r.startsReadOnly.call(t.nodeConstructor,e):!!r.startsReadOnly){const t=e.source;e.source="customMutation";try{return await body(e)}finally{e.source=t,application_1.Application.emitter.emit("customOperationExecuted",{})}}}const c={isolationLevel:s,isReadonly:!o,isDeferrable:r.isDeferrable,isDetachedContext:true};return e.withChildContext(body,c)}static makeResolver(e,t,r,a){const o=r.action?`${r.name}_${r.action}`:r.name,n=OperationType.makeParameterProperty(e,t.name,OperationType.combineOperationParameters(r),o,"parameter"),i=OperationType.makeGraphQlFactory(e,t.name,n,"parameter");return{description:a?`Mutation ${r.name}`:`Query ${r.name}`,type:property_type_1.PropertyType.makePropertyType(e,i,OperationType.makeParameterProperty(e,i.name,r.return,"return","return"),"return"),args:r.parameters.reduce((t,r)=>(t[r.name]={type:property_type_1.PropertyType.makePropertyType(e,i,OperationType.makeParameterProperty(e,i.name,r,r.name,"parameter"),"parameter")},t),{}),resolve(e,o,s){const{context:c}=s.xtrem;return access_rights_1.AccessRights.runSecure(c,r.name,{factory:{name:t.name},isMutation:a,args:o,operationAction:r.action},()=>(0,xtrem_shared_1.withRethrow)(()=>OperationType.execute(c,t,r,o,a,i,n),operation_error_1.OperationError.errorMapper(c,t,r.name)))}}}static addOperationFields(e,t,r,a,o,n){const i=(0,xtrem_shared_1.createDictionary)(),s=[];a.filter(e=>e.isPublished).forEach(r=>{const a=(0,lodash_1.camelCase)(r.name);if(a.startsWith("_")||n[a])throw new Error(`${t.fullName}.${a}: operation name conflicts with system operation`);const c=OperationType.makeResolver(e,t,r,o);if(r.action){if(!i[a])i[a]=(0,xtrem_shared_1.createDictionary)();if(i[a][r.action]=c,r.isGlobal)s.push(a)}else if(n[a]=c,r.isGlobal)e.addGlobalNamespaceEntry(a,c)}),Object.keys(i).forEach(t=>{const a=`${r}_${t}`,o=e.internType(a,()=>new graphql_1.GraphQLObjectType({name:a,fields:i[t]}));if(n[t]={type:o,resolve:()=>({})},s.includes(t))e.addGlobalNamespaceEntry(t,{type:o,resolve:()=>({})})})}}exports.OperationType=OperationType;
//# sourceMappingURL=operation-type.js.map