/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.NodeType=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),graphql_1=require("graphql"),lodash_1=require("lodash"),concurrency_utils_1=require("../../concurrency-utils"),properties_1=require("../../properties"),core_hooks_1=require("../../runtime/core-hooks"),loggers_1=require("../../runtime/loggers"),node_factory_utils_1=require("../../runtime/node-factory-utils"),aggregate_types_1=require("../aggregates/aggregate-types"),access_rights_1=require("../security/access-rights"),access_type_1=require("./access-type"),property_type_1=require("./property-type"),logger=loggers_1.loggers.graphQl,maskedPassword="********************";class NodeType{static isInput(e){return"nodeInput"===e||"parameter"===e}static publishedProperties(e,t){const r={},s=NodeType.isInput(t);let o=e;for(;o;)o.properties.filter(e=>{if(!e.isPublished)return false;if(r[e.name])return false;if(s)return e.isOnInputType||!e.isOutputOnly;return!e.isInputOnly}).forEach(e=>{r[e.name]=e}),o=o.baseFactory;const i=Object.values(e.publishedSystemProperties).filter(t=>!s||s&&e.publishedInputSystemProperties.includes(t.name));return Object.values(r).concat(i)}static getPropertyPath(e){const t=[],buildPath=e=>{if("string"==typeof e.key)t.unshift(e.key);if(e.prev)buildPath(e.prev)};return buildPath(e),t}static getSelectedProperties(e,t){const r=[],s=this.getPropertyPath(t.path).reverse(),walkSelectionSets=t=>{const o=s.pop();if(!o)return;const i=t.selections.find(e=>e.kind===graphql_1.Kind.FIELD&&e.name.value===o);if(!i)return;const a=i.selectionSet;if(0===s.length&&i.name.value===e)return void r.push(...t.selections.map(e=>e.name.value));if(!a)return;walkSelectionSets(a)};return walkSelectionSets(t.operation.selectionSet),r}static async resolveCustomFields(e,t,r){if(!e.customFields[t.fullName]){const s=await core_hooks_1.CoreHooks.customizationManager.getCustomFields(e,[t.fullName]);if(!s)throw r.logicError(`custom fields not found: ${t.name}`);Object.assign(e.customFields,s)}}static async resolveValue(e,t,r,s,o,i){const a=!await s.isEnabledByServiceOptions(t)||!await s.isAuthorized(t);let n;if(o?.selector&&"_customData"===s.name)await this.resolveCustomFields(t,e,s);if(!a)n=await r.$.state.getPropertyValue(s);else{const e=NodeType.getPropertyPath(i.path);if(!this.getSelectedProperties(s.name,i).includes("_access"))t.addRestrictedPropertyDiagnose(e);n=null}if(s.isCollectionProperty()){return n}if(n&&s.isJsonProperty()&&o?.selector)n=n[o?.selector];const p=property_type_1.PropertyType.getOutputValue(e,n,s);if(s.isStringProperty()&&s.isStoredEncrypted)return p?maskedPassword:"";return p}static nodeValuesIn(e,t,r,s){return e.prefetcher.visit(r,!!s?.forUpdate,t),(0,xtrem_async_helper_1.asyncArray)(Object.keys(t)).reduce(async(o,i)=>{const a=r.findProperty(i),n=await property_type_1.PropertyType.getInputValue(e,t[i],r,a);if(null!=n||!s?.omitNulls)o[a.name]=n;if(a.isStringProperty()&&a.isStoredEncrypted&&n===maskedPassword)delete o[a.name];return o},{})}static async nodeIn(e,t,r,s){return e.create(r.nodeConstructor,await NodeType.nodeValuesIn(e,t,r),{isTransient:s?.isTransientInput})}static getPropertyFieldDescription(e){if(e instanceof properties_1.Property)return(0,node_factory_utils_1.getPropertySchemaDescription)(e);return`Parameter ${e.name}`}static getPropertyFieldArgs(e,t){const r={};if("group"===t&&"reference"!==e.type)r.by={type:aggregate_types_1.groupByVerbsEnumType};if("json"===e.type)r.selector={type:graphql_1.GraphQLString};return r}static getPropertyFieldType(e,t,r,s){if(("values"===s||"group"===s)&&"collection"===t.type)return;if("values"===s&&"reference"!==t.type)return aggregate_types_1.AggregateTypes.getAggregateType(e,t);return property_type_1.PropertyType.makePropertyType(e,r,t,s)}static getPropertyFieldResolver(e,t,r){if("nodeOutput"===r)return(r,s,o,i)=>{const a=r.$.context;return access_rights_1.AccessRights.runSecure(a,e.name,{factory:t,isPropertyAccess:true},()=>NodeType.resolveValue(t,a,r,e,s,i))};if("values"===r||"group"===r){if("collection"===e.type)return;return(t,r,s,o)=>{const i=t[e.name];if(t&&"json"===e.type&&r?.selector)return Promise.resolve(i[r.selector]);return Promise.resolve(i)}}return}static makePropertyField(e,t,r,s,o){const i=o.typingMode,a=o.fieldName||r.name;if(!/[a-z]/i.test(a))throw new Error(`${s.fullName}.${a}: invalid property name`);const n=this.getPropertyFieldType(e,r,s,i);if(void 0===n)return;t[a]={description:this.getPropertyFieldDescription(r),type:n,args:this.getPropertyFieldArgs(r,i)};const p=this.getPropertyFieldResolver(r,s,i);if(null!=p)t[a].resolve=p}static makeCollectionPropertyFields(e,t,r,s,o){const i=r.rootProperty;if(s.isAbstract&&i.targetFactory.isAbstract)NodeType.makePropertyField(e,t,i,i.factory,{typingMode:o,fieldName:(0,lodash_1.camelCase)(`any ${r.name}`)});else{if(i!==r)NodeType.makePropertyField(e,t,i,i.factory,{typingMode:o,fieldName:(0,lodash_1.camelCase)(`any ${r.name}`)});NodeType.makePropertyField(e,t,r,s,{typingMode:o})}}static makeFields(e,t,r){let s=NodeType.publishedProperties(t,r.typingMode);if(0===s.length)throw new Error(`${t.name}: cannot create graphql type: no properties`);if(r.isThunk)s=s.filter(e=>"_id"===e.name);const o={};if("nodeOutput"===r.typingMode)o._access=(0,access_type_1.getAccessField)(t);return s.reduce((s,o)=>{if(("reference"===o.type||"referenceArray"===o.type)&&"sql"!==o.targetFactory.storage&&"external"!==o.targetFactory.storage)return logger.warn(`${t.name}.${o.name}: not published because target class is not persistent`),s;if(o instanceof properties_1.Property&&properties_1.foreignNodePropertyTypes.includes(o.type)&&!o.getValue&&!o.computeValue&&!(o.isCollectionProperty()&&o.getFilter)&&!o.join)return logger.warn(`${t.name}.${o.name}: not published because join and getValue are missing`),s;if("collection"===o.type)NodeType.makeCollectionPropertyFields(e,s,o,t,r.typingMode);else NodeType.makePropertyField(e,s,o,t,r);return s},o)}static makeOutputType(e,t,r,s){const o="group"===r||"values"===r;let i=(0,xtrem_shared_1.schemaTypeName)(t.fullName);switch(r){case"values":i+="_Values";break;case"group":i+="_Group"}return e.internType(i,()=>{const a=[];let n=t.baseFactory;for(;n;){const t=NodeType.makeOutputType(e,n,r,{isInterface:!o});if(!o)a.push(t);n=n.baseFactory}if(s?.isInterface||t.isAbstract&&!o)return this.makeInterface(i,a,e,t,r);return new graphql_1.GraphQLObjectType({interfaces:a,description:t.getNodeSchemaDescription(),name:i,fields:()=>NodeType.makeFields(e,t,{typingMode:r})})})}static makeInterface(e,t,r,s,o){return new graphql_1.GraphQLInterfaceType({interfaces:t,name:e,fields:()=>NodeType.makeFields(r,s,{typingMode:o}),resolveType:(e,t)=>{const{context:s}=t.xtrem;return(0,concurrency_utils_1.runResolver)(s,()=>r.getCached(e.$?.state?.factory?.name).name)}})}static makeInputType(e,t,r){const s=`${(0,xtrem_shared_1.schemaTypeName)(t.fullName)}_Input`;return e.internType(s,()=>new graphql_1.GraphQLInputObjectType({name:s,fields:()=>NodeType.makeFields(e,t,{typingMode:r})}))}}exports.NodeType=NodeType;
//# sourceMappingURL=node-type.js.map