/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.jsonType=exports.streamInputType=exports.binaryStreamOutputType=exports.textStreamOutputType=exports.datetimeType=exports.timeType=exports.datetimeRangeType=exports.dateRangeType=exports.dateType=exports.idInputType=exports.booleanInputType=exports.decimalType=exports.externalReferenceInputType=exports.referenceInputType=exports.floatInputType=exports.decimalRangeType=exports.stringArrayType=exports.integerArrayType=exports.integerRangeType=exports.integerInputType=void 0,exports.makeCustomEnumOutputType=makeCustomEnumOutputType,exports.makeCustomEnumInputType=makeCustomEnumInputType;const xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),xtrem_shared_1=require("@sage/xtrem-shared"),graphql_1=require("graphql"),json5=require("json5"),types_1=require("../../types");function makeNumberType(e,r,t){const resolveValue=e=>{if(t?.isReference){if(!e&&!t?.isExternal)return null;if(null==e&&t?.isExternal)return null;if("string"==typeof e){if(t?.isExternal)return e;if(e.startsWith("_id:"))return e;if(e.startsWith("{"))return json5.parse(e);if(e.startsWith("#"))return e}}const r=Number(e);if(t?.isGraphQLInt&&!(0,types_1.isInt32)(r))throw new xtrem_shared_1.LogicError(`Int cannot represent non 32-bit signed integer value: ${e}`);return r};return new graphql_1.GraphQLScalarType({name:e,description:r,serialize:e=>null==e?e:Number(e),parseValue:e=>null==e?e:resolveValue(e),parseLiteral(e){switch(e.kind){case graphql_1.Kind.STRING:case graphql_1.Kind.INT:case graphql_1.Kind.FLOAT:return resolveValue(e.value);case graphql_1.Kind.NULL:return null;default:throw new xtrem_shared_1.LogicError(`String or number expected, got ${e.kind}`)}}})}function makeScalarType(e,r,t,a){const resolveValue=e=>{if(a&&"string"==typeof e){if(e.startsWith("_id:"))return e;if(e.startsWith("#"))return e}return r(e)};return new graphql_1.GraphQLScalarType({name:e,description:t,serialize:e=>e?e.toString():null,parseValue:e=>e?resolveValue(e):null,parseLiteral(e){switch(e.kind){case graphql_1.Kind.STRING:return resolveValue(e.value);case graphql_1.Kind.NULL:return null;default:throw new xtrem_shared_1.LogicError(`String expected, got ${e.kind}`)}}})}function makeCustomEnumOutputType(e,r){return new graphql_1.GraphQLEnumType({name:e,values:r.values.reduce((e,r)=>(e[r]={value:r},e),{})})}function makeCustomEnumInputType(e,r){const t=`# Enum\n\nEnum value may be input as string and will be returned as string.\n\nValues:${r.values.map(e=>`\n- ${e}`).join("")}`,parseValue=e=>(r.validateMemberValue(e),e);return new graphql_1.GraphQLScalarType({name:e,description:t,serialize(t){if(""===t)return t;if(!Number.isFinite(Number(t)))return r.validateMemberValue(t),t;const a=r.stringValue(t);if(!a)throw new xtrem_shared_1.LogicError(`${e}: invalid value: ${t}`);return a},parseValue,parseLiteral(r){switch(r.kind){case graphql_1.Kind.ENUM:case graphql_1.Kind.STRING:return parseValue(r.value);default:throw new xtrem_shared_1.LogicError(`${e}: bad kind: ${r.kind}`)}}})}exports.integerInputType=makeNumberType("IntOrString","# Integer or string\n\nString will be converted to integer",{isGraphQLInt:true}),exports.integerRangeType=makeScalarType("IntegerRange",xtrem_date_time_1.IntegerRange.parse,"# IntegerRange --- format: [|d+,d+]|)",false),exports.integerArrayType=makeScalarType("IntegerArray",Array.from,"# IntegerArrayType --- format: [d+,d+,...])",false),exports.stringArrayType=makeScalarType("StringArray",Array.from,"# StringArrayType --- format: ['s','s',...])",false),exports.decimalRangeType=makeScalarType("DecimalRange",xtrem_date_time_1.DecimalRange.parse,"# DecimalRange --- format: [|d+,d+]|)",false),exports.floatInputType=makeNumberType("FloatOrString","# Float or string\n\nString will be converted to number"),exports.referenceInputType=makeNumberType("IntReference","# Number or string\n\nString will be converted to number except if it starts with '_id:'",{isReference:true}),exports.externalReferenceInputType=makeNumberType("ExternalReference","# Number or string'",{isReference:true,isExternal:true}),exports.decimalType=new graphql_1.GraphQLScalarType({name:"Decimal",description:"# Decimal\n\nDecimal value may be input as number or string and will be returned as string to get full precision",serialize:e=>null==e?e:`${e}`,parseValue:e=>null==e?e:xtrem_decimal_1.Decimal.make(e),parseLiteral(e){switch(e.kind){case graphql_1.Kind.STRING:case graphql_1.Kind.INT:case graphql_1.Kind.FLOAT:return null==e.value||""===e.value?null:xtrem_decimal_1.Decimal.make(e.value);case graphql_1.Kind.NULL:return null;default:throw new xtrem_shared_1.LogicError(`String or Int expected, got ${e.kind}`)}}}),exports.booleanInputType=new graphql_1.GraphQLScalarType({name:"BooleanOrString",description:"# Boolean\n\nBoolean value may be input as boolean or string and will be returned as boolean",serialize:e=>e.toString(),parseValue(e){if("boolean"==typeof e)return e;if("string"==typeof e)switch(e){case"true":return true;case"false":return false;default:throw new xtrem_shared_1.LogicError(`${e}: invalid boolean value`)}throw new xtrem_shared_1.LogicError(`${e}: invalid ${typeof e} value`)},parseLiteral(e){switch(e.kind){case graphql_1.Kind.BOOLEAN:return e.value;case graphql_1.Kind.STRING:switch(e.value){case"true":return true;case"false":return false;default:throw new xtrem_shared_1.LogicError(`${e.value}: invalid boolean value`)}default:throw new xtrem_shared_1.LogicError(`String or Boolean expected, got ${e.kind}`)}}}),exports.idInputType=makeScalarType("Id",e=>e,"# ID",true),exports.dateType=makeScalarType("Date",e=>xtrem_date_time_1.DateValue.parse(e),"# Date\n\nISO 8601 format: YYYY-MM-DD",false),exports.dateRangeType=makeScalarType("DateRange",xtrem_date_time_1.DateRange.parse,"# DateRange\n\nISO --- format: ([|()YYYY-MM-DD,YYYY-MM-DD(]|))",false),exports.datetimeRangeType=makeScalarType("DatetimeRange",xtrem_date_time_1.DatetimeRange.parse,"# DateRange\n\nISO --- format: ([|()YYYY-MM-DD,YYYY-MM-DD(]|))",false),exports.timeType=makeScalarType("Time",e=>xtrem_date_time_1.Time.parse(e),"# Time\n\nISO 8601 format: HH:mm:ss",false),exports.datetimeType=makeScalarType("Datetime",e=>xtrem_date_time_1.Datetime.parse(e),"# Datetime\n\nISO 8601 format: YYYY-MM-DD[T]HH:mm:ssZ",false),exports.textStreamOutputType=new graphql_1.GraphQLObjectType({name:"_OutputTextStream",fields:{value:{type:graphql_1.GraphQLString}}}),exports.binaryStreamOutputType=new graphql_1.GraphQLObjectType({name:"_OutputBinaryStream",fields:{value:{type:graphql_1.GraphQLString,resolve:e=>e?e.toString():null}}}),exports.streamInputType=new graphql_1.GraphQLInputObjectType({name:"_InputStream",fields:{value:{type:graphql_1.GraphQLString}}}),exports.jsonType=new graphql_1.GraphQLScalarType({name:"Json",description:"# JSON\n\nValue is input and returned as a string (stringified JSON)",serialize:e=>JSON.stringify(null!=e?e:null),parseValue:e=>null!=e?JSON.parse(e):null,parseLiteral(e){switch(e.kind){case graphql_1.Kind.STRING:return JSON.parse(e.value);case graphql_1.Kind.NULL:return null;default:throw new xtrem_shared_1.LogicError(`String expected, got ${e.kind}`)}}});
//# sourceMappingURL=basic-types.js.map