/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.AccessRights=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_metrics_1=require("@sage/xtrem-metrics"),xtrem_shared_1=require("@sage/xtrem-shared"),_=require("lodash"),concurrency_utils_1=require("../../concurrency-utils"),operation_error_1=require("../../errors/operation-error"),runtime_1=require("../../runtime"),loggers_1=require("../../runtime/loggers"),logger=loggers_1.loggers.authorization,loggerGraphQl=loggers_1.loggers.graphQl;class AccessRights{static runSecure(e,t,r,a){return logger.debug(()=>`runSecure -> operation: ${t}`),xtrem_metrics_1.CustomMetrics.graphql.withMetrics({nodeName:r.factory.name,operationName:t,operationKind:r.isMutation?"mutation":"query"},()=>(0,concurrency_utils_1.runResolver)(e,async()=>{await(0,xtrem_shared_1.withRethrow)(async()=>{if(r.isMutation)AccessRights.checkNotReadonly();await AccessRights.checkOperationAccessRight(e,{nodeName:r.factory.name,operationName:r.operation||t,args:r.args??{},isPropertyAccess:!!r.isPropertyAccess,isMutation:!!r.isMutation,operationAction:r.operationAction,parentNodeName:r.parentFactory?.name})},a=>new operation_error_1.OperationError(e,e.application.getFactoryByName(r.factory.name),t??r.operation,a instanceof xtrem_shared_1.ErrorWithDiagnoses?a.extensions.diagnoses??[]:[{severity:4,message:a.message,path:[]}],a));try{return await a()}catch(t){throw AccessRights.logInputData(e,r),t}}))}static isPackageAvailable(e,t){return xtrem_config_1.ConfigManager.current.storage?.managedExternal||"all"===t[0]||t.includes(e.name)}static checkNotReadonly(){if(xtrem_config_1.ConfigManager.current.graphql.isReadonly)throw new xtrem_shared_1.AuthorizationError("Mutations are not allowed. Endpoint is readonly")}static async isOperationAvailable(e,t){const{operationName:r,nodeName:a}=t,s=e.isServiceOptionEnabled.bind(e),o=e.application.getFactoryByName(a);if(o.serviceOptions&&!await(0,xtrem_async_helper_1.asyncArray)(o.serviceOptions).every(s))return false;if(t.isMutation){const e=o.mutations.find(e=>e.name===r);return(0,xtrem_async_helper_1.asyncArray)(e?.serviceOptions?.()||[]).every(s)}const i=o.queries.find(e=>e.name===r);return(0,xtrem_async_helper_1.asyncArray)(i?.serviceOptions?.()||[]).every(s)}static getAuthorizedByAccess(e,t,r,a,s,o){if(r?.authorizedBy){const i=t.nodeConstructor[r.authorizedBy];if("function"!=typeof i)throw t.logicError(`Authorization query ${a} is not a function`);const n=r.parameters.map(e=>s?s[e.name]:void 0);return i.apply(t.nodeConstructor,[{action:o,trackingId:s?.trackingId},e,...n])}if(t.authorizedBy)return t.authorizedBy(e,a,s);return}static async getUserAccessOnOperation(e,{nodeName:t,operationName:r,args:a,operationAction:s,bypassAuthorizedBy:o,parentNodeName:i}){const n=e.application.getFactoryByName(t),c=runtime_1.standardOperations.some(e=>e===r),u=c?void 0:n.getOperationByName(r,s),g=o?void 0:await AccessRights.getAuthorizedByAccess(e,n,u,r,a??{},s);if(g)return g;let p=await runtime_1.Context.accessRightsManager.getUserAccessFor(e,t,r,{parentNodeName:i});if(!p||"authorized"!==p.status){if(!c){const r="query"===u?.operationKind?u:void 0;if(r&&r.isGrantedByLookup)p=await runtime_1.Context.accessRightsManager.getUserAccessFor(e,t,"lookup")}if("read"===r&&!n.denyReadOnLookupOnlyAccess&&n.hasLookupAccess)p=await runtime_1.Context.accessRightsManager.getUserAccessFor(e,t,"lookup",{parentNodeName:i})}return p}static mergeUserAccess(e,t){if("unavailable"===e.status)return e;if("unavailable"===t.status)return t;if("inactive"===e.status)return e;if("inactive"===t.status)return t;if("unauthorized"===e.status)return e;if("unauthorized"===t.status)return t;const intersect=(e,t)=>{if(null==e)return t;if(null==t)return e;return _.intersection(e,t)};return{status:"authorized"===e.status&&"authorized"===t.status?"authorized":"readonly",sites:intersect(e.sites,t.sites),accessCodes:intersect(e.accessCodes,t.accessCodes)}}static async getUserAccessOnOperations(e,t){const r=await(0,xtrem_async_helper_1.asyncArray)(t).reduce(async(t,r)=>{const a=await AccessRights.getUserAccessOnOperation(e,r);return null==t?a:this.mergeUserAccess(t,a)},null);if(null==r)return{status:"unauthorized",sites:null,accessCodes:null};return r}static async checkOperationAccessRight(e,t){if(t.isPropertyAccess)return;const{nodeName:r,operationName:a,args:s,operationAction:o,parentNodeName:i}=t;if(!await AccessRights.isOperationAvailable(e,{nodeName:r,operationName:a,args:s,isMutation:!!t.isMutation,isPropertyAccess:t.isPropertyAccess}))throw await logger.infoAsync(()=>`Operation ${r}.${a}' is not enabled by the current configuration of the application`),new xtrem_shared_1.AuthorizationError(e.localize("@sage/xtrem-core/operation-not-enabled","Operation {{nodeName}}.{{operationName}} is not enabled by the configuration of the application",{nodeName:r,operationName:a}));const n=await AccessRights.getUserAccessOnOperation(e,{nodeName:r,operationName:a,args:s,operationAction:o,parentNodeName:i});if(await e.user&&(!n||"authorized"!==n.status))throw new xtrem_shared_1.AuthorizationError(e.localize("@sage/xtrem-core/user-not-allowed-operation","You do not have the rights to perform this operation {{nodeName}}.{{operation}}",{nodeName:r,operation:a}));e.setAllowedAccessCodes(n)}static logInputData(e,t){if(t.args&&e.request)loggerGraphQl.error(`input data: ${JSON.stringify(t.args,runtime_1.stringifyLogReplacer)}`)}}exports.AccessRights=AccessRights;
//# sourceMappingURL=access-rights.js.map