import { AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
import { Dict } from '@sage/xtrem-shared';
import { Package } from '../../application/package';
import { PlainOperationDecorator } from '../../decorators';
import { Context, NodeFactory, StandardOperation, UserAccess } from '../../runtime';
export interface AccessRightsOptions {
    factory: {
        name: string;
    };
    args?: Dict<any>;
    operation?: StandardOperation | string;
    /** Is this a mutation */
    isMutation?: boolean;
    /** Is this a property access operation */
    isPropertyAccess?: boolean;
    operationAction?: string;
    parentFactory?: {
        name: string;
    };
}
interface CheckOptions {
    nodeName: string;
    operationName: StandardOperation | string;
    args?: Dict<any>;
    isPropertyAccess?: boolean;
    isMutation?: boolean;
    operationAction?: string;
    parentNodeName?: string;
}
interface OperationAccessOptions {
    nodeName: string;
    operationName: string;
    args?: Dict<any>;
    operationAction?: string;
    bypassAuthorizedBy?: boolean;
    parentNodeName?: string;
}
/**
 * @disabled_internal
 *
 * Static class which provides methods to enforce access rights
 */
export declare class AccessRights {
    static runSecure<T extends AnyValue>(context: Context, operation: StandardOperation | string, options: AccessRightsOptions, body: () => AsyncResponse<T>): Promise<T>;
    static isPackageAvailable(pack: Package, activePackages: string[]): boolean;
    private static checkNotReadonly;
    static isOperationAvailable(context: Context, options: CheckOptions): Promise<boolean>;
    /**
     * Get authorizedBy access for a given operation
     * First check on operation level, then on factory level
     * @param context
     * @param factory
     * @param operation
     * @param operationName
     * @param args
     * @param operationAction
     * @returns
     */
    static getAuthorizedByAccess(context: Context, factory: NodeFactory, operation: PlainOperationDecorator | undefined, operationName: string, args?: Dict<any>, operationAction?: string): AsyncResponse<UserAccess | undefined>;
    private static getUserAccessOnOperation;
    static mergeUserAccess(userAccess1: UserAccess, userAccess2: UserAccess): UserAccess;
    static getUserAccessOnOperations(context: Context, operations: OperationAccessOptions[]): Promise<UserAccess>;
    static checkOperationAccessRight(context: Context, options: CheckOptions): Promise<void>;
    private static logInputData;
}
export {};
//# sourceMappingURL=access-rights.d.ts.map