/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SchemaBuilder=void 0;const graphql_1=require("graphql"),_=require("lodash"),lodash_1=require("lodash"),loggers_1=require("../runtime/loggers"),types_1=require("../types"),node_mutations_1=require("./mutations/node-mutations"),node_queries_1=require("./queries/node-queries"),access_rights_1=require("./security/access-rights"),enum_type_1=require("./types/enum-type"),type_cache_1=require("./utils/type-cache"),logger=loggers_1.loggers.graphQl;class SchemaBuilder{static createQueries(e,a,t){if(!access_rights_1.AccessRights.isPackageAvailable(t,a.tenantPackages))return{};return t.factories.filter(e=>e.nodeDecorator.isPublished).reduce((a,t)=>{const s=node_queries_1.NodeQueries.makeResolver(e,t);if(s)a[(0,lodash_1.camelCase)(t.name)]=s;return a},{})}static createMutations(e,a,t){if(!access_rights_1.AccessRights.isPackageAvailable(t,a.tenantPackages))return{};return t.factories.filter(e=>e.isPublished).reduce((a,t)=>{const s=node_mutations_1.NodeMutations.makeResolver(e,t);if(s)a[(0,lodash_1.camelCase)(t.name)]=s;return a},{})}static createTypes(e,a){const t=[];return Object.values(e.dataTypes).filter(e=>e instanceof types_1.EnumDataType).forEach(e=>{const s=e,r=enum_type_1.EnumType.getTypeName(s,false),i=enum_type_1.EnumType.getTypeName(s,true);if(void 0===a.getCached(r))t.push(enum_type_1.EnumType.makeGraphQLEnumType(a,s,false));if(void 0===a.getCached(i))t.push(enum_type_1.EnumType.makeGraphQLEnumType(a,s,true))}),t}static getNamespace(e,a,t){const s={},r={},i=e.version||"",c=e.getPackages().filter(e=>e.factories.some(e=>!!e.isPublished)).reduce((e,a)=>{const i=t(a);if(0===Object.keys(i).length)return e;const c=a.name.split("/"),n=c[0].startsWith("@")?c.shift():"",checkSegment=e=>{if("@sage"!==n&&e?.startsWith("xtrem-"))throw new Error("'xtrem' prefix is reserved!")};let o=e;for(;c.length>1;){const e=c.shift();checkSegment(e);const a=(0,lodash_1.camelCase)(e);if(!o[a])o[a]={name:a,fields:{},marker:s};o=o[a].fields}const l=c.shift();checkSegment(l);const u=(0,lodash_1.camelCase)(l);return o[u]=i,r[u]=`Package Version : ${a.packageJson.version}`,e},{}),wrapFields=e=>{if(e.marker!==s)return e;return Object.keys(e.fields).reduce((t,s)=>(t[s]={type:new graphql_1.GraphQLObjectType({name:s+a,fields:wrapFields(e.fields[s])}),description:r[s]||`Application Version : ${i}`,resolve:()=>({})},t),{})};return _.isEmpty(this.typeCache.globalNamespace)?wrapFields({fields:{...c},marker:s}):wrapFields({fields:{...c,global:this.typeCache.globalNamespace},marker:s})}static async getSchema(e,a){logger.info(()=>`Creating GraphQL schema for application ${e.name}`);const t=a?await a.getActivePackageNames():["all"];logger.verbose(()=>`GraphQL active packages: ${t.join()}`),this.typeCache=new type_cache_1.TypeCache(e);const s=loggers_1.loggers.graphQl.verbose(()=>`Create schema ${e.name}`),r=SchemaBuilder.getNamespace(e,"Query",e=>SchemaBuilder.createQueries(this.typeCache,{tenantPackages:t},e));this.typeCache.resetGlobalNamespace();const i=SchemaBuilder.getNamespace(e,"Mutation",e=>SchemaBuilder.createMutations(this.typeCache,{tenantPackages:t},e));if((0,lodash_1.isEmpty)(r)&&(0,lodash_1.isEmpty)(i))throw new Error("Cannot create an empty Graphql schema: you are missing both queries and mutations!");const c=SchemaBuilder.createTypes(e,this.typeCache),n=new graphql_1.GraphQLSchema({query:new graphql_1.GraphQLObjectType({name:"RootQueryType",fields:r}),...!(0,lodash_1.isEmpty)(i)&&{mutation:new graphql_1.GraphQLObjectType({name:"MutationsType",fields:i})},types:c,directives:[graphql_1.GraphQLSkipDirective,graphql_1.GraphQLIncludeDirective]});return s.success(),n}}exports.SchemaBuilder=SchemaBuilder;
//# sourceMappingURL=schema-builder.js.map