/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.LookupQuery=void 0;const graphql_1=require("graphql"),paging_1=require("../paging/paging"),access_rights_1=require("../security/access-rights"),node_type_1=require("../types/node-type"),lookup_total_count_1=require("./lookup-total-count");class LookupQuery{static makeLookupQueryType(e,o){const t=`${o.toString()}_Lookups_Reference`;return e.internType(t,()=>new graphql_1.GraphQLObjectType({name:t,fields:{totalCount:lookup_total_count_1.LookupTotalCount.makeResolver(),edges:paging_1.Paging.makeEdgesResolver(e,o),pageInfo:paging_1.Paging.makePageInfoResolver()}}))}static async lookupQuery(e,o){const t={...o.pagingOptions,first:o.pagingOptions.first&&o.pagingOptions.first+1,last:o.pagingOptions.last&&o.pagingOptions.last+1};if(!o.lookupArgs._id&&!o.lookupArgs.data)throw new Error(`${o.parentFactory.name}.${o.propertyName}: lookups missing id or data parameter`);if(o.lookupArgs.data)o.lookupArgs.data=await node_type_1.NodeType.nodeValuesIn(e,o.lookupArgs.data,o.parentFactory,{omitNulls:false});const r=await e.makeLookupQueryParameters(o.parentFactory.nodeConstructor,o.propertyName,o.lookupArgs);return e.lookup(r,t).toArray()}static makeResolver(e,o,t,r,a){return{type:LookupQuery.makeLookupQueryType(e,r),args:paging_1.Paging.getPagingArgumentTypes(),resolve(e,r,p,s){const{context:n}=p.xtrem;return access_rights_1.AccessRights.runSecure(n,"lookup",{factory:o,args:r,parentFactory:t},async()=>{const p={lookupArgs:e,factory:o,parentFactory:t,propertyName:a},g=n,u=await paging_1.Paging.parsePagingOptions(g,o,r,s,o.defaultOrderBy),i=await LookupQuery.lookupQuery(g,{...p,pagingOptions:u});return{context:g,pagePromise:paging_1.Paging.buildOutputPage({items:i},u,true),parentArgs:p}})}}}}exports.LookupQuery=LookupQuery;
//# sourceMappingURL=lookup-query.js.map