/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Paging=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),graphql_1=require("graphql"),runtime_1=require("../../runtime"),paging_filter_1=require("./paging-filter"),paging_order_by_1=require("./paging-order-by"),paging_types_1=require("./paging-types"),defaultPageSize=20,defaultMaxPerPage=1e3,defaultStreamMaxPerPage=1e5;class Paging{static getPagingArgumentTypes(){return{first:{type:graphql_1.GraphQLInt},after:{type:graphql_1.GraphQLString},last:{type:graphql_1.GraphQLInt},before:{type:graphql_1.GraphQLString},filter:{type:graphql_1.GraphQLString},orderBy:{type:graphql_1.GraphQLString}}}static async buildOutputPage(e,r,t=false){const a=await(0,xtrem_async_helper_1.asyncArray)(e.items).map(async e=>({node:e,cursor:await e.$.state.getCursorValue(r.orderBy||{})})).toArray();if(r.last){const i=e.items.length>r.last;let n=i?a.slice(0,a.length-1):a;if(t)n=n.slice().reverse();return{edges:n,pageInfo:{hasNextPage:null!=r.before,endCursor:n.length>0?n[n.length-1].cursor:void 0,hasPreviousPage:i,startCursor:n.length>0?n[0].cursor:void 0,totalCount:e.totalCount}}}const i=e.items.length>r.first;{const t=i?a.slice(0,a.length-1):a;return{edges:t,pageInfo:{hasNextPage:i,endCursor:t.length>0?t[t.length-1].cursor:void 0,hasPreviousPage:null!=r.after,startCursor:t.length>0?t[0].cursor:void 0,totalCount:e.totalCount}}}}static async addInternalFilters(e,r,t,a){const i="lookups"===a.path.prev?.key?"lookup":"read",n=[t,await r.getConstructorFilter(e,i),await runtime_1.Context.accessRightsManager.getOperationSecurityFilter(e,r,i)].filter(e=>void 0!==e);return n.length<=1?n.shift():{_and:n}}static async parsePagingOptions(e,r,t,a,i,n){const s=xtrem_config_1.ConfigManager.current.graphql?.maxNodesPerPage||defaultMaxPerPage,g=!!n?.groups?.length&&!t.orderBy?void 0:await paging_order_by_1.PagingOrderBy.parseOrderBy(e,r,t.orderBy,i),o=await this.addInternalFilters(e,r,await paging_filter_1.PagingFilter.parseFilter(e,r,t.filter),a);if(t.last){if(t.first)throw new Error("first cannot be supplied with last.");if(t.after)throw new Error("after cannot be supplied with last.");return{last:Math.min(t.last,s),before:t.before,orderBy:g,filter:o,aggregate:n}}if(t.before)throw new Error("before cannot be supplied without last.");const queryContainsStreamDirective=()=>a.schema.getDirectives().some(e=>"stream"===e.name)&&a.fieldNodes.some(e=>e?.selectionSet?.selections.some(e=>e.directives?.some(e=>"stream"===e.name.value)));return{first:(e=>{if(null==e)return queryContainsStreamDirective()?defaultStreamMaxPerPage:Math.min(defaultPageSize,s);return Math.min(e>=0?e:s,s)})(t.first),after:t.after,orderBy:g,filter:o,aggregate:n}}static async addCollectionFilter(e,r){e.collection=r,e.filter=e.filter?{_and:[e.filter,await r.joinValues]}:await r.joinValues}static makeEdgeType(e,r){const t=`${r.toString()}_Edge`;return e.internType(t,()=>new graphql_1.GraphQLObjectType({name:t,fields:{node:{type:r},cursor:{type:graphql_1.GraphQLString}}}))}static makeEdgesResolver(e,r){return{type:new graphql_1.GraphQLList(Paging.makeEdgeType(e,r)),resolve(e){if(!e.pagePromise&&!e.edges)throw new Error("internal error: cannot resolve edges");return e.pagePromise?e.pagePromise.then(e=>e.edges):e.edges}}}static makePageInfoResolver(){return{type:paging_types_1.pageInfoType,resolve:e=>e.pagePromise?e.pagePromise.then(e=>e.pageInfo):e.pageInfo}}}exports.Paging=Paging;
//# sourceMappingURL=paging.js.map