/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.PagingFilter=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_ts_to_sql_1=require("@sage/xtrem-ts-to-sql"),_=require("lodash"),lodash_1=require("lodash"),runtime_1=require("../../runtime"),core_hooks_1=require("../../runtime/core-hooks"),node_factory_utils_1=require("../../runtime/node-factory-utils"),property_type_1=require("../types/property-type");class PagingFilter{static getRestrictedPropertyNames(e,r,t){return(0,xtrem_async_helper_1.asyncArray)(r.properties.filter(e=>t.includes(e.name))).filter(async r=>!await r.isEnabledByServiceOptions(e)||!await r.isAuthorized(e)).map(e=>e.name).toArray()}static async extractAllowedFilterProperties(e,r,t,i=[]){const a=await PagingFilter.getRestrictedPropertyNames(e,r,Object.keys(t));return(0,lodash_1.intersection)(Object.keys(t),a).map(e=>[...i,e]).forEach(r=>e.addRestrictedFilterDiagnose(r)),(0,lodash_1.omit)(t,a)}static verifyFunctionValue(e,r,t){const i=[],a=new xtrem_ts_to_sql_1.Converter(e,r,{resolveColumnName(e,r,t){const i=r.factory.propertiesByName[t],a=i&&i.isForeignNodeProperty()?i.targetFactory:r.factory;return{path:r.path?`${r.path}.${t}`:t,alias:r.alias,factory:a,type:i?.type||"unknown",property:i,sql:t}},resolveTableName:e=>e.table?.sqlTableName||e.tableName||e.name,resolveLiteral:e=>"string"==typeof e?e:`${e}`},{dialect:"postgres",beforeWalkCallback:e=>{i.push(e)}});if(a.convertFunctionBody(a.convertThisExpression(),t),0===i.length)return true;const n=i.reduce((e,r)=>{if(null!=_.get(e,r))return e;return _.set(e,r,{}),e},{}),walker=(r,t)=>{if(_.isEmpty(r))return true;return(0,xtrem_async_helper_1.asyncArray)(Object.keys(r)).every(async i=>{const a=t.propertiesByName[i];if(!a){if("object"==typeof r[i])return walker(r[i],t);return true}if(await a.isEnabledByServiceOptions(e)&&await a.isAuthorized(e)){if("object"==typeof r[i]&&a.isForeignNodeProperty())return walker(r[i],a.targetFactory);return true}return false})};return walker(n,r)}static applyAllowedFilters(e,r,t,i,a){return(0,xtrem_async_helper_1.asyncArray)(Object.keys(t)).reduce(async(n,o)=>{const s=t[o],l=r.propertiesByName[o];let c;if(!l){if("_"!==o[0])throw new xtrem_shared_1.DataInputError(`${r.name}.${o}: Property not found`);if("_regex"===o||"_options"===o){if(!(0,runtime_1.isScalar)(s))throw new xtrem_shared_1.DataInputError(`Invalid value for ${o} on ${i.join(".")}`);c=String(s)}else if("_fn"===o)if(await this.verifyFunctionValue(e,r,t[o]))c=String(s);else e.addRestrictedFilterDiagnose([...i,o]);else c=await PagingFilter.convertFilter(e,r,s,[...i,o],a)}else if(l.isReferenceProperty()&&s&&(0,runtime_1.isCompound)(s)||l.isCollectionProperty()||l.isReferenceArrayProperty()){const r=l.targetFactory;if(l.isCollectionProperty()&&"sql"===r.storage&&!l.reverseReference)throw l.inputError("Nested filter on collection property without reverse reference is not supported");c=await PagingFilter.convertFilter(e,r,s,[...i,o])}else c=await PagingFilter.convertFilter(e,r,s,[...i,o],l);if(void 0!==c)n[o]=c;return n},{})}static async convertFilter(e,r,t,i=[],a){if(!t)return t;if(Array.isArray(t)){if(0===t.length)return[];const n=(await(0,xtrem_async_helper_1.asyncArray)(t).map((t,n)=>PagingFilter.convertFilter(e,r,t,[...i,String(n)],a)).toArray()).filter(e=>void 0!==e);return 0===n.length?void 0:n}if(Object.keys(t).find(e=>"_customData"===e)){const t=await(core_hooks_1.CoreHooks.customizationManager?.getCustomFields(e,[r.fullName]));if(t)Object.assign(e.customFields,t)}if((0,runtime_1.isScalar)(t)||a?.isArrayProperty()&&Array.isArray(t)){if(a)return property_type_1.PropertyType.getInputValue(e,t,r,a);return t}if(a?.type&&["json","date","dateRange","datetimeRange","integerRange","decimalRange"].includes(a.type))return t;const n=await PagingFilter.extractAllowedFilterProperties(e,r,t,i),o=await PagingFilter.applyAllowedFilters(e,r,n,i,a);if(0!==i.length&&0===Object.keys(o).length)return;return o}static async parseFilter(e,r,t){const i=t&&(0,node_factory_utils_1.friendlyJsonParse)(t);if("string"==typeof i){const r='Invalid filter (parsed value is a string, expected an object): "{{filter}}"',t=e.localize("@sage/xtrem-core/invalid-filter",r,{filter:`"${i}"`}).replace(/&quot;/g,'"').replace(/&#x27;/g,"'");throw new xtrem_shared_1.DataInputError(t)}return await PagingFilter.convertFilter(e,r,i)}}exports.PagingFilter=PagingFilter;
//# sourceMappingURL=paging-filter.js.map