/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.DeleteMutation=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),graphql_1=require("graphql"),operation_error_1=require("../../errors/operation-error"),access_rights_1=require("../security/access-rights"),node_type_1=require("../types/node-type"),property_type_1=require("../types/property-type");class DeleteMutation{static readTypeArgs(e,t){const r={};return t.keyProperties.forEach(o=>{r[o.name]={type:new graphql_1.GraphQLNonNull(property_type_1.PropertyType.makePropertyType(e,t,o,"nodeInput"))}}),r}static async executeDelete(e,t,r,o){if("deleteById"===r){const r={_id:o._id},a=await e.tryRead(t.nodeConstructor,r,{forUpdate:true});if(!a)return 0;return await a.$.delete(),1}let a={};try{a=await node_type_1.NodeType.nodeValuesIn(e,o,t)}catch{return 0}return t.deleteMany(e,a)}static makeResolver(e,t,r){return{description:`Delete a ${t.name}`,type:graphql_1.GraphQLInt,args:"deleteById"===r?{_id:{type:graphql_1.GraphQLID}}:DeleteMutation.readTypeArgs(e,t),resolve(e,o,a){const{context:s}=a.xtrem;return access_rights_1.AccessRights.runSecure(s,r,{factory:t,isMutation:true,operation:"delete",args:o},()=>s.withChildContext(e=>(0,xtrem_shared_1.withRethrow)(()=>DeleteMutation.executeDelete(e,t,r,o),operation_error_1.OperationError.errorMapper(e,t,"delete")),{isolationLevel:t.getIsolationLevel("delete")}))}}}}exports.DeleteMutation=DeleteMutation;
//# sourceMappingURL=delete-mutation.js.map