/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.CreateUpdateMutations=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),graphql_1=require("graphql"),lodash_1=require("lodash"),operation_error_1=require("../../errors/operation-error"),loggers_1=require("../../runtime/loggers"),access_rights_1=require("../security/access-rights"),node_type_1=require("../types/node-type"),operationLogger=loggers_1.loggers.operation;class CreateUpdateMutations{static async executeCreateOrUpdate(e,t,a,r,o){const{dataAtlevel:i,factoryAtlevel:n,keyAtlevel:s,pathAtlevel:d,reversedPathAtlevel:l}=await CreateUpdateMutations.transformVitalChildPayloadToParentPayload(e,t,o,[],[]);if(d.length>0)return CreateUpdateMutations.createOrUpdateVitalParent(e,i,n,s,d,l);if("create"===a){const a=await node_type_1.NodeType.nodeIn(e,o,t);return await a.$.save(),a}const p=await node_type_1.NodeType.nodeValuesIn(e,o,t),u="external"===t.storage?"updateById"===a?{_id:r}:(0,lodash_1.pick)(p,[...t.keyProperties.map(e=>e.name),"_id"]):{_id:"updateById"===a?r:p._id},c=await e.read(t.nodeConstructor,u,{forUpdate:true});if(null!=p._etag){const t=String(await c.$.etag);if(p._etag!==t)throw e.businessRuleError({key:"@sage/xtrem-core/record-modified-reload-required",message:"Another user made changes to this record. Refresh the page to add your changes."})}return await c.$.update(p),c}static makeResolver(e,t,a){return{description:`${(0,lodash_1.capitalize)(a)} a ${t.name}`,type:node_type_1.NodeType.makeOutputType(e,t,"nodeOutput"),args:{_id:{type:graphql_1.GraphQLID},data:{type:node_type_1.NodeType.makeInputType(e,t,"nodeInput")}},resolve(e,r,o){const{context:i}=o.xtrem;return access_rights_1.AccessRights.runSecure(i,a,{factory:t,isMutation:true,operation:"create"===a?a:"update",args:r},()=>i.withChildContext(e=>(0,xtrem_shared_1.withRethrow)(()=>CreateUpdateMutations.executeCreateOrUpdate(e,t,a,r._id,r.data),operation_error_1.OperationError.errorMapper(e,t,"updateById"===a?"update":a)),{isolationLevel:t.getIsolationLevel("create"===a?"create":"update")}))}}}static hasVitalParentPayload(e,t){return e.isVitalChild&&e.vitalParentProperty.isVitalParentInput&&null!=t[e.vitalParentProperty.name]&&"object"==typeof t[e.vitalParentProperty.name]&&"sql"===e.storage}static pickKeyPropertiesValueFromPayload(e,t){return t._id?{_id:t._id}:(0,lodash_1.pick)(t,[...e.keyProperties.map(e=>e.name),"_id"])}static async transformVitalChildPayloadToParentPayload(e,t,a,r,o){if(CreateUpdateMutations.hasVitalParentPayload(t,a)){const{vitalParentFactory:i}=t;if(1!==i.properties.filter(e=>e.isReferenceProperty()&&e.targetFactory.name===t.name).length)throw new xtrem_shared_1.BusinessRuleError(`Vital parent property ${t.vitalParentProperty.name} must have a unique child property ${t.name}`);const n=await node_type_1.NodeType.nodeValuesIn(e,a[t.vitalParentProperty.name],i),s=CreateUpdateMutations.pickKeyPropertiesValueFromPayload(i,n),d=t.getReverseVitalProperty();if(d){if(n[d.name]=await node_type_1.NodeType.nodeValuesIn(e,(0,lodash_1.omit)(a,t.vitalParentProperty.name),t),r.unshift(d.name),o.unshift(t.vitalParentProperty.name),i.isVitalChild)return CreateUpdateMutations.transformVitalChildPayloadToParentPayload(e,i,n,r,o);return{dataAtlevel:n,factoryAtlevel:i,keyAtlevel:s,pathAtlevel:r,reversedPathAtlevel:o}}}const i=CreateUpdateMutations.pickKeyPropertiesValueFromPayload(t,a);return{dataAtlevel:a,factoryAtlevel:t,keyAtlevel:i,pathAtlevel:r,reversedPathAtlevel:o}}static async createOrUpdateVitalParent(e,t,a,r,o,i){let n=(0,lodash_1.isEmpty)(r)?void 0:await e.tryRead(a.nodeConstructor,r,{forUpdate:true});try{if(!n)operationLogger.info(()=>`Creating the vital parent node ${a.name}`),n=await e.create(a.nodeConstructor,t);else operationLogger.info(()=>`Updating the vital parent node ${a.name}`),await n.$.set(t);return await n.$.save(),await n.$.get(o.join("."))}catch(t){throw CreateUpdateMutations.fixDiagnosesPaths(e,o,i),t}}static fixDiagnosesPaths(e,t,a){if(t.length>0)e.diagnoses.forEach(e=>{const r=[...e.path],o=r.filter(e=>!t.includes(e)),i=r.findIndex(e=>e===o[0]);e.path=o.length===r.length&&1===a.length?[...r]:[...a.slice(i).reverse(),...o]})}}exports.CreateUpdateMutations=CreateUpdateMutations;
//# sourceMappingURL=create-update-mutations.js.map