/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.BulkUpdateMutation=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),graphql_1=require("graphql"),ts_api_1=require("../../ts-api"),access_rights_1=require("../security/access-rights"),node_type_1=require("../types/node-type"),bulk_utils_1=require("../utils/bulk-utils");class BulkUpdateMutation{static makeResolver(e,t){return{description:`Bulk update ${t.name}`,type:graphql_1.GraphQLBoolean,args:{filter:{type:graphql_1.GraphQLString},data:{type:node_type_1.NodeType.makeInputType(e,t,"nodeInput")}},resolve(e,r,a){const{context:s}=a.xtrem;return access_rights_1.AccessRights.runSecure(s,"update",{factory:t,isMutation:true,operation:"update",args:r},()=>s.withChildContext(e=>(0,xtrem_shared_1.withRethrow)(async()=>(await(0,bulk_utils_1.executeBulkAction)(e,r.filter,t.nodeConstructor,{body:async(e,a)=>{const s=await node_type_1.NodeType.nodeValuesIn(e,r.data,t,{forUpdate:true});await a.$.set(s),await a.$.save()}}),true),ts_api_1.OperationError.errorMapper(e,t,"bulkUpdate")),{isolationLevel:t.getIsolationLevel("update")}))}}}}exports.BulkUpdateMutation=BulkUpdateMutation;
//# sourceMappingURL=bulk-update-mutation.js.map