/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getUserInfoSchemaFragment=void 0;const xtrem_metrics_1=require("@sage/xtrem-metrics"),graphql_1=require("graphql"),concurrency_utils_1=require("../../concurrency-utils"),runtime_1=require("../../runtime"),client_service_1=require("../../system/pages/client-service"),userInfoType=new graphql_1.GraphQLObjectType({name:"_UserInfo",fields:{_id:{type:graphql_1.GraphQLString},firstName:{type:graphql_1.GraphQLString},lastName:{type:graphql_1.GraphQLString},userCode:{type:graphql_1.GraphQLString},email:{type:graphql_1.GraphQLString},photo:{type:graphql_1.GraphQLString},bookmarks:{type:new graphql_1.GraphQLList(graphql_1.GraphQLString)},history:{type:new graphql_1.GraphQLList(graphql_1.GraphQLString)},uniqueUserId:{type:graphql_1.GraphQLString},uniqueTenantId:{type:graphql_1.GraphQLString},clientEncryptionKey:{type:graphql_1.GraphQLString}}}),getUserInfoSchemaFragment=()=>({queries:{userInfo:{type:userInfoType,resolve:(e,r,t)=>xtrem_metrics_1.CustomMetrics.metadata.withMetrics({nodeName:"sitemap",operationName:"read",operationKind:"query"},()=>{const{context:e}=t.xtrem;return(0,concurrency_utils_1.runResolver)(e,async()=>{const r=await client_service_1.ClientService.getUniqueUserId(e),t=client_service_1.ClientService.getUniqueTenantId(e),i=await client_service_1.ClientService.getDefaultUserEncryptionKey(e),a=await e.user;if(a){const n=runtime_1.Context.accessRightsManager.getUserNavigation?await runtime_1.Context.accessRightsManager.getUserNavigation(e):{};return{_id:a._id,firstName:a.firstName,lastName:a.lastName,userCode:a.userName,email:a.email,history:n.history||[],bookmarks:n.bookmarks||[],photo:a.photo?.value.toString("base64"),clientEncryptionKey:a.clientEncryptionKey||i,uniqueUserId:r,uniqueTenantId:t}}return null})})}}});exports.getUserInfoSchemaFragment=getUserInfoSchemaFragment;
//# sourceMappingURL=user-info-fragment.js.map