/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getSitemapSchemaFragment=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_i18n_1=require("@sage/xtrem-i18n"),xtrem_metrics_1=require("@sage/xtrem-metrics"),graphql_1=require("graphql"),concurrency_utils_1=require("../../concurrency-utils"),loggers_1=require("../../runtime/loggers"),client_service_1=require("../../system/pages/client-service"),logger=loggers_1.loggers.application,sitemapEntryType=new graphql_1.GraphQLObjectType({name:"_SitemapEntry",fields:()=>({id:{type:graphql_1.GraphQLString},title:{type:graphql_1.GraphQLString},icon:{type:graphql_1.GraphQLString},isPage:{type:graphql_1.GraphQLBoolean},priority:{type:graphql_1.GraphQLInt},children:{type:sitemapEntryListType}})}),sitemapEntryListType=new graphql_1.GraphQLList(sitemapEntryType),resolveSitemapElements=async(e,t,r,i)=>{if(0===t.length)return t;let a=(0,xtrem_async_helper_1.asyncArray)(t).filter(e=>{const t=0===r.length||null!=e?.packageName&&r.includes(e?.packageName);if(!t)logger.debug(()=>`resolveSitemapElements don't keep element title:${e.title} packageName:${e.packageName}`);return t}).filter(async t=>{if(t.isPage){const r=await client_service_1.ClientService.userHasAccessToPage(e,t.id);if(!r)logger.debug(()=>`resolveSitemapElements don't keep element ${t.title||t.id}`);return r}return true});if(await a.length>0)return a=a.map(async t=>{const a={...t};a.children=await resolveSitemapElements(e,a.children||[],r,i);const n=a.isPage?(0,xtrem_i18n_1.artifactReferenceToTitleStringKey)(a.id,"pages"):(0,xtrem_i18n_1.menuItemIdToStringKey)(a.id);return a.title=(0,xtrem_i18n_1.getLiteral)(n,i).content,a}),a.filter(e=>{const t=e.isPage||e.children&&e.children.length>0;if(!t)logger.debug(()=>`resolveSitemapElements don't keep element ${e.title} isPage:${e.isPage} children:${e.children?e.children.length:0}`);return!!t}).toArray();return[]},resolveSitemap=(e,t,r)=>xtrem_metrics_1.CustomMetrics.metadata.withMetrics({nodeName:"sitemap",operationName:"read",operationKind:"query"},()=>{const{context:e}=r.xtrem;return(0,concurrency_utils_1.runResolver)(e,async()=>{const t=(0,xtrem_i18n_1.getLocaleFromHeader)(e.request.headers),r=await e.getActivePackageNames();return logger.debug(()=>`resolveSitemap(activePackages:${r})`),resolveSitemapElements(e,await client_service_1.ClientService.getSitemapTree(e),r,t)})}),getSitemapSchemaFragment=()=>({queries:{sitemap:{type:sitemapEntryListType,resolve:resolveSitemap}}});exports.getSitemapSchemaFragment=getSitemapSchemaFragment;
//# sourceMappingURL=sitemap-fragment.js.map