/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getPrintingSettingsSchemaFragment=void 0;const xtrem_metrics_1=require("@sage/xtrem-metrics"),graphql_1=require("graphql"),concurrency_utils_1=require("../../concurrency-utils"),core_hooks_1=require("../../runtime/core-hooks"),artifact_manager_1=require("../../system/artifact-manager"),client_service_1=require("../../system/pages/client-service"),isPageAccessible=async(e,t)=>{if(!t)return false;const i=await artifact_manager_1.ArtifactManager.readClientArtifact(e,client_service_1.ClientArtifactType.pages,{exactMatch:true,packageOrPage:t}),r=await client_service_1.ClientService.getPageAccess(e,i?.pageAccess,{authorizationCode:i?.authorizationCode,pageNode:i?.pageNode}),n=await client_service_1.ClientService.getPageAccess(e,i?.extensionAccess,{authorizationCode:i?.authorizationCode,pageNode:i?.pageNode});return"authorized"===r&&"authorized"===n},printingSettingsRootType=new graphql_1.GraphQLObjectType({name:"_ReportingSettingsRoot",fields:{printingAssignmentDialogUrl:{type:graphql_1.GraphQLString},canAccessPrintingAssignmentDialog:{type:graphql_1.GraphQLBoolean},listPrintingWizardUrl:{type:graphql_1.GraphQLString},canAccessListPrintingWizard:{type:graphql_1.GraphQLBoolean},recordPrintingWizardUrl:{type:graphql_1.GraphQLString},recordPrintingGlobalBulkMutationName:{type:graphql_1.GraphQLString},listPrintingGlobalMutationConfigPage:{type:graphql_1.GraphQLString},canAccessRecordPrintingWizard:{type:graphql_1.GraphQLBoolean}}}),getPrintingSettingsSchemaFragment=()=>({queries:{printingSettings:{type:printingSettingsRootType,resolve:(e,t,i)=>xtrem_metrics_1.CustomMetrics.metadata.withMetrics({nodeName:"printingSettings",operationName:"read",operationKind:"query"},()=>{const{context:e}=i.xtrem;return(0,concurrency_utils_1.runResolver)(e,async()=>{const t=core_hooks_1.CoreHooks.createPrintingManager(e);if(!t)return null;const i=await t.getPrintingAssignmentDialogUrl(),r=await t.getListPrintingWizardUrl(),n=await t.getRecordPrintingWizardUrl(),a=await t.getRecordPrintingGlobalBulkMutationName(),g=await t.getRecordListPrintingGlobalBulkActionConfigurationURL();return{printingAssignmentDialogUrl:i,canAccessPrintingAssignmentDialog:isPageAccessible(e,i),listPrintingWizardUrl:r,canAccessListPrintingWizard:isPageAccessible(e,r),recordPrintingWizardUrl:n,canAccessRecordPrintingWizard:isPageAccessible(e,n),listPrintingGlobalMutationConfigPage:g,recordPrintingGlobalBulkMutationName:a}})})}}});exports.getPrintingSettingsSchemaFragment=getPrintingSettingsSchemaFragment;
//# sourceMappingURL=printing-settings-fragment.js.map