/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getNotificationSchemaFragment=void 0;const graphql_1=require("graphql"),concurrency_utils_1=require("../../concurrency-utils"),notificationActionType=new graphql_1.GraphQLObjectType({name:"_NotificationAction",fields:{_id:{type:graphql_1.GraphQLString},title:{type:graphql_1.GraphQLString},link:{type:graphql_1.GraphQLString},style:{type:new graphql_1.GraphQLEnumType({name:"_NotificationActionStyle",values:{primary:{value:"primary"},secondary:{value:"secondary"},tertiary:{value:"tertiary"},link:{value:"link"}}})}}}),notificationActionListType=new graphql_1.GraphQLList(notificationActionType),notificationType=new graphql_1.GraphQLObjectType({name:"_Notification",fields:{_id:{type:graphql_1.GraphQLString},_createStamp:{type:graphql_1.GraphQLString},level:{type:new graphql_1.GraphQLEnumType({name:"_NotificationLevel",values:{error:{value:"error"},warning:{value:"warning"},info:{value:"info"},success:{value:"success"},approval:{value:"approval"}}})},shouldDisplayToast:{type:graphql_1.GraphQLBoolean},isRead:{type:graphql_1.GraphQLBoolean},icon:{type:graphql_1.GraphQLString},title:{type:graphql_1.GraphQLString},description:{type:graphql_1.GraphQLString},actions:{type:notificationActionListType}}}),notificationListType=new graphql_1.GraphQLList(notificationType),markReadMutation={type:graphql_1.GraphQLBoolean,args:{_id:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)}},resolve:(e,t,a)=>{const{context:i}=a.xtrem;return(0,concurrency_utils_1.runResolver)(i,()=>i.application.requestFunnel(()=>i.withChildContext(e=>i.application.notificationManager.markRead(e,t._id),{isolationLevel:"low"})))}},markUnreadMutation={type:graphql_1.GraphQLBoolean,args:{_id:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)}},resolve:(e,t,a)=>{const{context:i}=a.xtrem;return(0,concurrency_utils_1.runResolver)(i,()=>i.application.requestFunnel(()=>i.withChildContext(e=>i.application.notificationManager.markUnread(e,t._id),{isolationLevel:"low"})))}},deleteMutation={type:graphql_1.GraphQLBoolean,args:{_id:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)}},resolve:(e,t,a)=>{const{context:i}=a.xtrem;return(0,concurrency_utils_1.runResolver)(i,()=>i.application.requestFunnel(()=>i.withChildContext(e=>i.application.notificationManager.delete(e,t._id),{isolationLevel:"low"})))}},markAllReadMutation={type:graphql_1.GraphQLBoolean,resolve:(e,t,a)=>{const{context:i}=a.xtrem;return(0,concurrency_utils_1.runResolver)(i,()=>i.application.requestFunnel(()=>i.withChildContext(e=>i.application.notificationManager.markAllRead(e),{isolationLevel:"low"})))}},notificationMutationType=new graphql_1.GraphQLObjectType({name:"_NotificationsMutation",fields:{markRead:markReadMutation,markUnread:markUnreadMutation,markAllRead:markAllReadMutation,delete:deleteMutation}}),getNotificationSchemaFragment=()=>({queries:{notifications:{type:notificationListType,resolve:(e,t,a)=>{const{context:i}=a.xtrem;return(0,concurrency_utils_1.runResolver)(i,()=>i.application.requestFunnel(()=>i.application.notificationManager.getUserNotifications(i)))}}},mutations:{notifications:{type:notificationMutationType,resolve:()=>({})}}});exports.getNotificationSchemaFragment=getNotificationSchemaFragment;
//# sourceMappingURL=notification-fragment.js.map