/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.NodeOperations=void 0;const lodash_1=require("lodash"),loggers_1=require("../../runtime/loggers"),operationLogger=loggers_1.loggers.operation;class NodeOperations{static getLocalizedTitle(e,a,n){const o=n.definingPackage?.name!==a.package.name,t=o?n.definingPackage?.name:a.package.name,r=o?"node-extensions":"nodes",s=(0,lodash_1.snakeCase)(o?n.className:a.name);let i="";switch(n.operationKind){case"mutation":i=`${t}/${r}__${(0,lodash_1.snakeCase)(o?n.className:a.name)}__mutation__${n.name}`;break;case"asyncMutation":i=`${t}/${r}__${s}__asyncMutation__${n.name}`;break;case"query":i=`${t}/${r}__${s}__query__${n.name}`;break;default:throw Error(`${n.operationKind} operation is not localized`)}try{return e.localize(i,n.name)}catch{return operationLogger.warn(`Could not resolve localized title for property name: ${a.name}.${n.name}, key: ${i}`),n.name}}static getLocalizedParameter(e,a,n,o){const t=n.definingPackage?.name!==a.package.name,r=t?n.definingPackage?.name:a.package.name,s=t?"node-extensions":"nodes",i=(0,lodash_1.snakeCase)(t?n.className:a.name);let _="";switch(n.operationKind){case"mutation":_=`${r}/${s}__${i}__mutation__${n.name}__parameter__${o.name}`;break;case"asyncMutation":_=`${r}/${s}__${i}__asyncMutation__${n.name}__parameter__${o.name}`;break;case"query":_=`${r}/${s}__${i}__query__${n.name}__parameter__${o.name}`;break;default:throw Error(`${n.operationKind} operation is not localized`)}try{return e.localize(_,o.name)}catch{return operationLogger.warn(`Could not resolve localized parameter name: ${a.name}.${n.name}.${o.name}, key ${_}`),o.name}}}exports.NodeOperations=NodeOperations;
//# sourceMappingURL=node-operations.js.map