/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.expandNodeNames=exports.resolveArtifact=exports.pagesArgsWithFilter=exports.artifactArgsWithFilter=exports.getArtifactDescriptionConfig=exports.getArtifactTitleConfig=exports.getArtifactStringsConfig=exports.localizationsType=exports.accessListType=exports.pluginsType=exports.fragmentsType=exports.extensionsListType=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_i18n_1=require("@sage/xtrem-i18n"),xtrem_metrics_1=require("@sage/xtrem-metrics"),graphql_1=require("graphql"),lodash_1=require("lodash"),concurrency_utils_1=require("../../concurrency-utils"),core_hooks_1=require("../../runtime/core-hooks"),artifact_manager_1=require("../../system/artifact-manager"),client_service_1=require("../../system/pages/client-service"),extensionsType=new graphql_1.GraphQLObjectType({name:"_PageExtension",fields:{packageName:{type:graphql_1.GraphQLString},content:{type:graphql_1.GraphQLString}}});exports.extensionsListType=new graphql_1.GraphQLList(extensionsType),exports.fragmentsType=new graphql_1.GraphQLList(new graphql_1.GraphQLObjectType({name:"_PageFragment",fields:{name:{type:graphql_1.GraphQLString},packageName:{type:graphql_1.GraphQLString},content:{type:graphql_1.GraphQLString}}})),exports.pluginsType=new graphql_1.GraphQLList(graphql_1.GraphQLString);const accessStatusType=new graphql_1.GraphQLObjectType({name:"_AccessStatus",fields:{name:{type:graphql_1.GraphQLString},status:{type:graphql_1.GraphQLString}}}),bindingsType=new graphql_1.GraphQLList(accessStatusType),accessType=new graphql_1.GraphQLObjectType({name:"_Access",fields:{node:{type:graphql_1.GraphQLString},bindings:{type:bindingsType}}});exports.accessListType=new graphql_1.GraphQLList(accessType);const localizationType=new graphql_1.GraphQLObjectType({name:"_Strings",fields:{key:{type:graphql_1.GraphQLString},content:{type:graphql_1.GraphQLString}}});exports.localizationsType=new graphql_1.GraphQLList(localizationType);const getArtifactStringsConfig=e=>({type:exports.localizationsType,resolve:(t,r,a)=>{const{context:i}=a.xtrem;return(0,concurrency_utils_1.runResolver)(i,()=>artifact_manager_1.ArtifactManager.resolveArtifactStrings(i,e,t))}});exports.getArtifactStringsConfig=getArtifactStringsConfig;const getArtifactTitleConfig=e=>({type:graphql_1.GraphQLString,resolve:(t,r,a)=>{const{context:i}=a.xtrem;return(0,concurrency_utils_1.runResolver)(i,()=>artifact_manager_1.ArtifactManager.getArtifactTitle(i,e,t))}});exports.getArtifactTitleConfig=getArtifactTitleConfig;const getArtifactDescriptionConfig=e=>({type:graphql_1.GraphQLString,resolve:(t,r,a)=>{const{context:i}=a.xtrem;return(0,concurrency_utils_1.runResolver)(i,()=>artifact_manager_1.ArtifactManager.getArtifactDescription(i,e,t))}});exports.getArtifactDescriptionConfig=getArtifactDescriptionConfig,exports.artifactArgsWithFilter={filter:{type:new graphql_1.GraphQLInputObjectType({name:"_ArtifactFilter",fields:{packageOrPage:{type:graphql_1.GraphQLString},exactMatch:{type:graphql_1.GraphQLBoolean,defaultValue:false}}})}},exports.pagesArgsWithFilter={filter:{type:new graphql_1.GraphQLInputObjectType({name:"_PagesFilter",fields:{packageOrPage:{type:graphql_1.GraphQLString},exactMatch:{type:graphql_1.GraphQLBoolean,defaultValue:false},pageNode:{type:graphql_1.GraphQLString,defaultValue:""}}})}};const resolveArtifact=(e,t)=>(r,a,i)=>xtrem_metrics_1.CustomMetrics.metadata.withMetrics({nodeName:t,operationName:"read",operationKind:"query"},()=>{const{context:r}=i.xtrem;return(0,concurrency_utils_1.runResolver)(r,async()=>{const i=(0,xtrem_i18n_1.getLocaleFromHeader)(r.request.headers);let s=[];if(a&&a.filter)if(a.filter.exactMatch){s=[await artifact_manager_1.ArtifactManager.readClientArtifact(r,t,a.filter)]}else s=await client_service_1.ClientService.searchClientArtifactsFromStorage(r,t,a.filter,i);else s=await artifact_manager_1.ArtifactManager.listAllClientArtifactsFromStorage(r,t);const n=await r.getActivePackageNames();return await(0,xtrem_async_helper_1.asyncArray)(s.filter(e=>0===n.length||e?.packageName&&n.includes(e?.packageName))).filter(async e=>{if(t!==client_service_1.ClientArtifactType.pages&&t!==client_service_1.ClientArtifactType.stickers)return true;return"authorized"===await client_service_1.ClientService.getPageAccess(r,e?.pageAccess,{authorizationCode:e?.authorizationCode,pageNode:e?.pageNode})}).map(async a=>{const i={...a};if(t===client_service_1.ClientArtifactType.widgets&&i.key&&i.category){const t=await core_hooks_1.CoreHooks.createDashboardManager(e).getWidgetCategory(r,{_id:i.key,id:i.category});if(t)i.category=t.key,i.categoryLabel=t.title}return i}).toArray()})});exports.resolveArtifact=resolveArtifact;const expandNodeNames=(e,t,r)=>{const a={};return t.forEach(t=>expandNodeName(e,t,r||5,a)),Object.keys(a)};exports.expandNodeNames=expandNodeNames;const expandNodeName=(e,t,r,a)=>{if(!(0,lodash_1.isNil)(a[t])&&a[t]>=r)return;a[t]=r;e.getFactoryByName(t).properties.forEach(t=>{if(t.isForeignNodeProperty())if(r>1)expandNodeName(e,t.targetFactory.name,r-1,a)})};
//# sourceMappingURL=metadata-schema-utils.js.map