import { GraphQLFieldConfig, GraphQLFieldConfigArgumentMap, GraphQLFieldConfigMap, GraphQLList, GraphQLObjectType } from 'graphql';
import { Application } from '../../application/application';
import { ArtifactFilter } from '../../system/artifact-manager';
import { ApplicationArtifact, ClientArtifactType } from '../../system/pages/client-service';
import { GraphqlContext } from '../types/basic-types';
export interface MetadataSchemaFragment {
    queries?: GraphQLFieldConfigMap<any, any>;
    mutations?: GraphQLFieldConfigMap<any, any>;
}
export declare const extensionsListType: GraphQLList<GraphQLObjectType<any, any>>;
export declare const fragmentsType: GraphQLList<GraphQLObjectType<any, any>>;
export declare const pluginsType: GraphQLList<import("graphql").GraphQLScalarType<string, string>>;
export declare const accessListType: GraphQLList<GraphQLObjectType<any, any>>;
export declare const localizationsType: GraphQLList<GraphQLObjectType<any, any>>;
export declare const getArtifactStringsConfig: (artifactType: ClientArtifactType) => GraphQLFieldConfig<ApplicationArtifact, GraphqlContext>;
export declare const getArtifactTitleConfig: (artifactType: ClientArtifactType) => GraphQLFieldConfig<ApplicationArtifact, GraphqlContext>;
export declare const getArtifactDescriptionConfig: (artifactType: ClientArtifactType) => GraphQLFieldConfig<ApplicationArtifact, GraphqlContext>;
export declare const artifactArgsWithFilter: GraphQLFieldConfigArgumentMap;
export declare const pagesArgsWithFilter: GraphQLFieldConfigArgumentMap;
export declare const resolveArtifact: (application: Application, artifactType: ClientArtifactType) => (_obj: unknown, args: {
    filter: ArtifactFilter;
}, graphqlContext: GraphqlContext) => Promise<{
    extensions?: string[];
    plugins?: string[];
    menuItem?: string;
    priority?: number;
    strings?: import("@sage/xtrem-i18n").LocalizedLiteral[];
    className?: string | undefined;
    md5?: string;
    title?: string;
    authorizationCode?: string;
    pageAccess?: import("../..").AccessBinding;
    pageNode?: string;
    extensionAccess?: import("../..").AccessBinding;
    category?: string;
    group?: string;
    categoryLabel?: string;
    type?: string;
    extends?: string;
    fragments?: string[];
    parentMenuItem?: string;
    listIcon?: string;
    description?: string;
    duplicateBindings?: string[];
    literals?: import("@sage/xtrem-i18n").ClientArtifactUsedLiterals;
    nodes?: string[];
    key?: string | undefined;
    packageName?: string | undefined;
    content?: import("../..").TextStream | undefined;
    artifactFilePath?: string | undefined;
}[]>;
export type SchemaFragmentFunction = (application: Application) => MetadataSchemaFragment;
export declare const expandNodeNames: (application: Application, nodeNames: string[], depth: number | null) => string[];
//# sourceMappingURL=metadata-schema-utils.d.ts.map