/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getDashboardSchemaFragment=void 0;const graphql_1=require("graphql"),concurrency_utils_1=require("../../concurrency-utils"),core_hooks_1=require("../../runtime/core-hooks"),dashboardItemPosition=new graphql_1.GraphQLObjectType({name:"_DashboardItemPosition",fields:{x:{type:graphql_1.GraphQLInt},y:{type:graphql_1.GraphQLInt},w:{type:graphql_1.GraphQLInt},h:{type:graphql_1.GraphQLInt},breakpoint:{type:new graphql_1.GraphQLEnumType({name:"_DashboardItemPositionBreakpoint",values:{xxs:{value:"xxs"},xs:{value:"xs"},sm:{value:"sm"},md:{value:"md"},lg:{value:"lg"}}})}}}),dashboardItem=new graphql_1.GraphQLObjectType({name:"_DashboardItem",fields:{_id:{type:graphql_1.GraphQLString},type:{type:graphql_1.GraphQLString},settings:{type:graphql_1.GraphQLString},positions:{type:new graphql_1.GraphQLList(dashboardItemPosition)}}}),dashboardType=new graphql_1.GraphQLObjectType({name:"_Dashboard",fields:{_id:{type:graphql_1.GraphQLString},title:{type:graphql_1.GraphQLString},description:{type:graphql_1.GraphQLString},icon:{type:graphql_1.GraphQLString},children:{type:new graphql_1.GraphQLList(dashboardItem)},isTemplate:{type:graphql_1.GraphQLBoolean}}}),dashboardNoChildrenType=new graphql_1.GraphQLObjectType({name:"_DashboardWithoutChildren",fields:{_id:{type:graphql_1.GraphQLString},title:{type:graphql_1.GraphQLString},listIcon:{type:graphql_1.GraphQLString},description:{type:graphql_1.GraphQLString}}}),widgetType=new graphql_1.GraphQLObjectType({name:"_Widget",fields:{key:{type:graphql_1.GraphQLString},title:{type:graphql_1.GraphQLString}}}),dashboardNoChildrenListType=new graphql_1.GraphQLList(dashboardNoChildrenType),widgetListType=new graphql_1.GraphQLList(widgetType),dashboardRootType=new graphql_1.GraphQLObjectType({name:"_DashboardRoot",fields:{selectedDashboard:{type:dashboardType,args:{group:{type:graphql_1.GraphQLString}},resolve:(e,a,r)=>{const{context:t}=r.xtrem;return(0,concurrency_utils_1.runResolver)(t,()=>core_hooks_1.CoreHooks.createDashboardManager(t.application).getSelectedDashboard(t,a.group))}},availableDashboards:{type:dashboardNoChildrenListType,args:{group:{type:graphql_1.GraphQLString}},resolve:(e,a,r)=>{const{context:t}=r.xtrem;return(0,concurrency_utils_1.runResolver)(t,async()=>{const e=await core_hooks_1.CoreHooks.createDashboardManager(t.application).getDashboardList(t,a.group);return Object.keys(e).map(a=>({_id:a,title:e[a]}))})}},templates:{type:dashboardNoChildrenListType,args:{group:{type:graphql_1.GraphQLString}},resolve:(e,a,r)=>{const{context:t}=r.xtrem;return(0,concurrency_utils_1.runResolver)(t,()=>core_hooks_1.CoreHooks.createDashboardManager(t.application).getFactoryDashboardList(t,a.group))}},getWidgetCategories:{type:widgetListType,resolve:(e,a,r)=>{const{context:t}=r.xtrem;return(0,concurrency_utils_1.runResolver)(t,()=>core_hooks_1.CoreHooks.createDashboardManager(t.application).getWidgetCategories(t))}},canEditDashboards:{type:graphql_1.GraphQLBoolean,resolve:(e,a,r)=>{const{context:t}=r.xtrem;return(0,concurrency_utils_1.runResolver)(t,()=>core_hooks_1.CoreHooks.createDashboardManager(t.application).canEditDashboards(t))}}}}),updateDashboardLayoutMutation={type:dashboardType,args:{dashboardId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)},layout:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)}},resolve:(e,a,r)=>{const{context:t}=r.xtrem;return(0,concurrency_utils_1.runResolver)(t,()=>{const e=JSON.parse(a.layout);return t.application.requestFunnel(()=>t.withChildContext(r=>core_hooks_1.CoreHooks.createDashboardManager(r.application).updateDashboardLayout(r,a.dashboardId,e),{isolationLevel:"low"}))})}},updateWidgetSettingsMutation={type:graphql_1.GraphQLBoolean,args:{dashboardItemId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)},settings:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)}},resolve:(e,a,r)=>{const{context:t}=r.xtrem;return(0,concurrency_utils_1.runResolver)(t,async()=>{const e=JSON.parse(a.settings);return await t.application.requestFunnel(()=>t.withChildContext(r=>core_hooks_1.CoreHooks.createDashboardManager(r.application).updateDashboardItemSettings(r,a.dashboardItemId,e),{isolationLevel:"low"})),true})}},createDashboardMutation={type:dashboardType,args:{group:{type:graphql_1.GraphQLString}},resolve:(e,a,r)=>{const{context:t}=r.xtrem;return(0,concurrency_utils_1.runResolver)(t,()=>t.application.requestFunnel(()=>t.withChildContext(e=>core_hooks_1.CoreHooks.createDashboardManager(e.application).createDashboard(e,a.group),{isolationLevel:"low"})))}},deleteDashboardMutation={type:graphql_1.GraphQLBoolean,args:{dashboardId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)}},resolve:(e,a,r)=>{const{context:t}=r.xtrem;return(0,concurrency_utils_1.runResolver)(t,()=>t.application.requestFunnel(()=>t.withChildContext(e=>core_hooks_1.CoreHooks.createDashboardManager(e.application).deleteDashboard(e,a.dashboardId),{isolationLevel:"low"})))}},selectDashboardMutation={type:dashboardType,args:{dashboardId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)},group:{type:graphql_1.GraphQLString}},resolve:(e,a,r)=>{const{context:t}=r.xtrem;return(0,concurrency_utils_1.runResolver)(t,()=>t.application.requestFunnel(()=>t.withChildContext(e=>core_hooks_1.CoreHooks.createDashboardManager(e.application).setSelectedDashboard(e,a.dashboardId,a.group),{isolationLevel:"low"})))}},cloneDashboardMutation={type:dashboardType,args:{dashboardId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)}},resolve:(e,a,r)=>{const{context:t}=r.xtrem;return(0,concurrency_utils_1.runResolver)(t,()=>t.application.requestFunnel(()=>t.withChildContext(e=>core_hooks_1.CoreHooks.createDashboardManager(e.application).cloneDashboard(e,a.dashboardId),{isolationLevel:"low"})))}},dashboardMutationType=new graphql_1.GraphQLObjectType({name:"_DashboardRootMutation",fields:{updateWidgetSettings:updateWidgetSettingsMutation,updateDashboardLayout:updateDashboardLayoutMutation,createDashboard:createDashboardMutation,cloneDashboard:cloneDashboardMutation,deleteDashboard:deleteDashboardMutation,selectDashboard:selectDashboardMutation}}),getDashboardSchemaFragment=()=>({queries:{dashboard:{type:dashboardRootType,resolve:()=>({})}},mutations:{dashboard:{type:dashboardMutationType,resolve:()=>({})}}});exports.getDashboardSchemaFragment=getDashboardSchemaFragment;
//# sourceMappingURL=dashboard-fragment.js.map