/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getClientUserSettingsSchemaFragment=void 0;const graphql_1=require("graphql"),concurrency_utils_1=require("../../concurrency-utils"),basic_types_1=require("../types/basic-types"),userSetting=new graphql_1.GraphQLObjectType({name:"_MetaClientUserSetting",fields:{_id:{type:graphql_1.GraphQLString},content:{type:basic_types_1.jsonType},elementId:{type:graphql_1.GraphQLString},title:{type:graphql_1.GraphQLString},description:{type:graphql_1.GraphQLString}}}),userSettingList=new graphql_1.GraphQLList(userSetting),clientUserSettingsRootType=new graphql_1.GraphQLObjectType({name:"_ClientUserSettingsRoot",fields:{variantsForElement:{type:userSettingList,args:{screenId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)},elementId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)}},resolve:(e,t,n)=>{const{context:r}=n.xtrem;return(0,concurrency_utils_1.runResolver)(r,()=>r.application.requestFunnel(()=>r.withChildContext(e=>e.application.clientSettingsManager.getVariantsForElement(e,t.screenId,t.elementId),{isolationLevel:"low"})))}},activeUserSettings:{type:userSettingList,args:{screenId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)}},resolve:(e,t,n)=>{const{context:r}=n.xtrem;return(0,concurrency_utils_1.runResolver)(r,()=>r.application.requestFunnel(()=>r.withChildContext(e=>e.application.clientSettingsManager.getActiveClientSettingsForArtifact(e,t.screenId),{isolationLevel:"low"})))}},listPage:{type:graphql_1.GraphQLString,resolve:(e,t,n)=>{try{const{context:e}=n.xtrem;return e.application.clientSettingsManager.getCustomizationListPage(e)}catch{return null}}},editPage:{type:graphql_1.GraphQLString,resolve:(e,t,n)=>{try{const{context:e}=n.xtrem;return e.application.clientSettingsManager.getCustomizationEditPage(e)}catch{return null}}}}}),updateUserClientSetting={type:userSetting,args:{_id:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)},content:{type:basic_types_1.jsonType},title:{type:graphql_1.GraphQLString},description:{type:graphql_1.GraphQLString}},resolve:(e,t,n)=>{const{context:r}=n.xtrem;return(0,concurrency_utils_1.runResolver)(r,()=>r.application.requestFunnel(()=>r.withChildContext(e=>e.application.clientSettingsManager.updateClientSetting(e,t._id,t.content,t.title||"",t.description||""),{isolationLevel:"low"})))}},createUserClientSetting={type:userSetting,args:{screenId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)},elementId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)},content:{type:basic_types_1.jsonType},title:{type:graphql_1.GraphQLString},description:{type:graphql_1.GraphQLString}},resolve:(e,t,n)=>{const{context:r}=n.xtrem;return(0,concurrency_utils_1.runResolver)(r,()=>r.application.requestFunnel(()=>r.withChildContext(e=>e.application.clientSettingsManager.createClientSetting(e,t.screenId,t.elementId,t.content,t.title||"",t.description||""),{isolationLevel:"low"})))}},setCurrentUserClientSetting={type:userSetting,args:{_id:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)},screenId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)},elementId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)}},resolve:(e,t,n)=>{const{context:r}=n.xtrem;return(0,concurrency_utils_1.runResolver)(r,()=>r.application.requestFunnel(()=>r.withChildContext(e=>e.application.clientSettingsManager.selectClientSetting(e,t.screenId,t.elementId,t._id),{isolationLevel:"low"})))}},unselectClientUserSettings={type:userSetting,args:{screenId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)},elementId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)}},resolve:(e,t,n)=>{const{context:r}=n.xtrem;return(0,concurrency_utils_1.runResolver)(r,()=>r.application.requestFunnel(()=>r.withChildContext(e=>e.application.clientSettingsManager.unselectedClientSetting(e,t.screenId,t.elementId),{isolationLevel:"low"})))}},resetClientSettings={type:graphql_1.GraphQLBoolean,resolve:(e,t,n)=>{const{context:r}=n.xtrem;return(0,concurrency_utils_1.runResolver)(r,()=>r.application.requestFunnel(()=>r.withChildContext(e=>e.application.clientSettingsManager.resetClientSettings(e),{isolationLevel:"low"})))}},deleteUserClientSetting={type:userSetting,args:{_id:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)}},resolve:(e,t,n)=>{const{context:r}=n.xtrem;return(0,concurrency_utils_1.runResolver)(r,()=>r.application.requestFunnel(()=>r.withChildContext(e=>e.application.clientSettingsManager.deleteClientSetting(e,t._id),{isolationLevel:"low"})))}},clientUserSettingsMutationType=new graphql_1.GraphQLObjectType({name:"_ClientUserSettingsRootMutation",fields:{createUserClientSetting,deleteUserClientSetting,resetClientSettings,setCurrentUserClientSetting,unselectClientUserSettings,updateUserClientSetting}}),getClientUserSettingsSchemaFragment=()=>({queries:{clientUserSettings:{type:clientUserSettingsRootType,resolve:()=>({})}},mutations:{clientUserSettings:{type:clientUserSettingsMutationType,resolve:()=>({})}}});exports.getClientUserSettingsSchemaFragment=getClientUserSettingsSchemaFragment;
//# sourceMappingURL=client-user-settings-fragment.js.map