/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.GraphQlHelper=void 0;const plugin_defer_stream_1=require("@graphql-yoga/plugin-defer-stream"),xtrem_shared_1=require("@sage/xtrem-shared"),chai_1=require("chai"),fs=require("fs"),graphql_yoga_1=require("graphql-yoga"),lodash=require("lodash"),fsp=require("path"),loggers_1=require("../runtime/loggers"),graphql_plugins_1=require("./graphql-plugins"),yoga_utils_1=require("./utils/yoga-utils");class GraphQlHelper{constructor(e){this.schema=e}execute(e,r,t){const executeWithContext=async()=>{const a=[(0,plugin_defer_stream_1.useDeferStream)()];if(false!==t?.withExtensions)a.push((0,graphql_plugins_1.diagnosesExtensionPlugin)());const s=(0,graphql_yoga_1.createYoga)({...(0,yoga_utils_1.getCommonGraphqlYogaArguments)(this.schema,e),graphiql:false,plugins:a}),i=await s.fetch("http://localhost/graphql",{method:"POST",headers:{"content-type":"application/json"},body:JSON.stringify({query:r,variables:t?.variables})}),n=await i.json();if(n.errors&&!t?.dontThrow)throw loggers_1.loggers.graphQl.error(`graphql request failed: ${n.errors}`),e.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.error,[""],n.errors[0].message),n.errors[0];if(t?.withDiagnoses)n.extensions={...n.extensions||{},diagnoses:e.diagnoses};return n};if(null==e.request?.body)e.request={...e.request,method:"POST",baseUrl:"/api",route:{path:"{/*path}"},headers:{},body:{query:r}};if(!t?.isolationOptions)return executeWithContext();return e.withChildContext(executeWithContext,t.isolationOptions)}executeChunked(e,r,t){const executeWithContext=async()=>{const a=(0,graphql_yoga_1.createYoga)({schema:this.schema,context:()=>({xtrem:{context:e}}),graphiql:false,landingPage:false,cors:false,maskedErrors:false,parserAndValidationCache:false,plugins:[(0,graphql_plugins_1.diagnosesExtensionPlugin)(),(0,plugin_defer_stream_1.useDeferStream)()]}),s=(await a.fetch("http://localhost/graphql",{method:"POST",headers:{"content-type":"application/json"},body:JSON.stringify({query:r,variables:t?.variables})})).body,i=[];if(s){const e=s.getReader();let r="",t=false;for(;!t;){const{value:a,done:s}=await e.read();if(a)r+="string"==typeof a?a:Buffer.from(a).toString();t=s}r.split("\n").filter(e=>e.trim().length>0).forEach(e=>{try{const r=JSON.parse(e);i.push(r)}catch{}})}return i};if(!t?.isolationOptions)return executeWithContext();return e.withChildContext(executeWithContext,t.isolationOptions)}static mergeChunks(e){const[r,...t]=e;if(!("data"in r))throw new Error("First chunk does not have a data property");return lodash.merge({},r.data,...t.map(e=>{if(e.path)return lodash.set({},e.path,e.data);if(e.incremental)return e.incremental.reduce((e,r)=>{if(r.path){const t=lodash.get(e,r.path,(0,xtrem_shared_1.createPlainObject)());if(r.items)return r.items.forEach(a=>{lodash.set(e,r.path??"",lodash.merge(t,a))}),e;return lodash.set(e,r.path,lodash.merge(t,r.data))}if(r.data)return lodash.merge(e,r.data);return e},(0,xtrem_shared_1.createDictionary)());return e.data}))}static unwrap(e,r){return chai_1.assert.isObject(e),chai_1.assert.isObject(e.data),chai_1.assert.isObject(e.data?.[r]),e.data[r]}async query(e,r,t){const a=t?.rootQueryType??"xtremCore",s=await this.execute(e,`{ ${a} ${r} }`,t);return GraphQlHelper.unwrap(s,a)}async mutation(e,r,t){const a=t?.rootQueryType??"xtremCore",s=await this.execute(e,`mutation { ${a} ${r} }`,t);return GraphQlHelper.unwrap(s,a)}async runScenario(e,r,t,a={}){const s=fsp.join(t,r,"request.graphql"),i=fsp.join(t,r,"response.json"),n=fs.readFileSync(s,"utf8"),o=JSON.parse(fs.readFileSync(i,"utf8"));if(a.format)fs.writeFileSync(i,`${JSON.stringify(o,null,4)}\n`);const l=await this.execute(e,n,a.graphqlOptions);if(a.update)fs.writeFileSync(i,`${JSON.stringify(l,null,4)}\n`);chai_1.assert.deepEqual(l,o)}}exports.GraphQlHelper=GraphQlHelper;
//# sourceMappingURL=graphql-helper.js.map