import { AnyValue } from '@sage/xtrem-async-helper';
import { Dict } from '@sage/xtrem-shared';
import { ExecutionResult, GraphQLSchema } from 'graphql';
import { ExecutionPatchResult } from '../interop/interop-graphql-client';
import { Context } from '../runtime';
import { IsolationOptions } from '../ts-api';
export interface GraphQlSetupOptions {
    rootQueryType?: string;
    isolationOptions?: IsolationOptions;
    withDiagnoses?: boolean;
    dontThrow?: boolean;
    withExtensions?: boolean;
    variables?: Dict<any>;
}
export type AsyncExecutionResult<TypeData = {
    [key: string]: unknown;
}, TypeExtensions = {
    [key: string]: unknown;
}> = ExecutionResult<TypeData, TypeExtensions> | AsyncGenerator<ExecutionPatchResult<TypeData, TypeExtensions>, void, void>;
export declare class GraphQlHelper {
    private schema;
    constructor(schema: GraphQLSchema);
    execute<T extends AnyValue>(context: Context, q: string, options?: GraphQlSetupOptions): Promise<ExecutionResult<T>>;
    /**
     * Executes a request containing `@stream` and/or `@defer` directives.
     * This method waits for all the chunks and returns a single result.
     * It is only meant for testing. A real client should process the chunks as they arrive,
     * to get the real benefits of these directives.
     */
    executeChunked(context: Context, q: string, options?: GraphQlSetupOptions): Promise<AsyncExecutionResult[]>;
    /**
     * Merges chunks returned by a graphql request containing `@stream` and/or `@defer` directives.
     */
    static mergeChunks<T extends Dict<any>>(chunks: AsyncExecutionResult[]): T;
    private static unwrap;
    query<T extends AnyValue>(context: Context, q: string, options?: GraphQlSetupOptions): Promise<T>;
    mutation<T extends AnyValue>(context: Context, q: string, options?: GraphQlSetupOptions): Promise<T>;
    runScenario(context: Context, scenario: string, dir: string, options?: {
        format?: boolean;
        update?: boolean;
        graphqlOptions?: GraphQlSetupOptions;
    }): Promise<void>;
}
//# sourceMappingURL=graphql-helper.d.ts.map