/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.graphQlTimeLimitInSeconds=void 0,exports.setGraphQlTransactionName=setGraphQlTransactionName,exports.graphQlApp=graphQlApp,exports.getTenantId=getTenantId,exports.graphQlMetadata=graphQlMetadata;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_i18n_1=require("@sage/xtrem-i18n"),xtrem_metrics_1=require("@sage/xtrem-metrics"),express=require("express"),graphql_yoga_1=require("graphql-yoga"),__1=require(".."),runtime_1=require("../runtime"),security_1=require("../security"),test_1=require("../test"),metadata_schema_1=require("./metadata-schema"),request_1=require("./utils/request"),yoga_utils_1=require("./utils/yoga-utils"),defaultGraphQlTimeLimitInSeconds=e=>e?.managedExternal?120:27.5,graphQlTimeLimitInSeconds=()=>xtrem_config_1.ConfigManager.current.graphql?.timeLimitInSeconds||defaultGraphQlTimeLimitInSeconds({managedExternal:!!xtrem_config_1.ConfigManager.current.storage?.managedExternal});function createExpressApp(){return express().disable("x-powered-by")}function setGraphQlTransactionName(e){(0,xtrem_metrics_1.setWebTransactionName)(()=>(0,request_1.setGraphQlHint)(e))}async function checkTenantId(e,t){if(xtrem_config_1.ConfigManager.current.storage?.managedExternal)return true;if(!(await runtime_1.Context.tenantManager.listTenantsIds(e)).includes(e.tenantId??""))return security_1.logger.error(`${xtrem_config_1.ConfigManager.current.app}~${e.tenantId}: Tenant does not exist`),t.status(200).send({data:{},errors:[{extensions:{diagnoses:[{severity:__1.ValidationSeverity.error,message:`${xtrem_config_1.ConfigManager.current.app}: Tenant does not exist`}]}}]}),false;return true}function graphQlApp(e,t){const a=createExpressApp();return a.all("{/*path}",(a,r)=>{setGraphQlTransactionName(a);const n=r.locals.config,i=(0,xtrem_i18n_1.getLocaleFromHeader)(a.headers),s=t?.graphqlTimeLimitInSeconds??(n.graphql?.timeLimitInSeconds||defaultGraphQlTimeLimitInSeconds({managedExternal:!!n.storage?.managedExternal})),o=performance.now()+1e3*s,executeRequest=async n=>{if(!await checkTenantId(n,r))return;const i=await e.getGraphQLSchema(n),s=(0,yoga_utils_1.getCommonGraphqlYogaArguments)(i,n),o=(0,graphql_yoga_1.createYoga)({...s,graphqlEndpoint:t?.endpoint||"/api",graphiql:{...t?.graphiqlDisabled?false:s.graphiql}});await o.handle(a,r)};return e.requestFunnel(()=>e.withReadonlyContext(getTenantId(e,n),async e=>{const t=a.body?.isolationLevel;if(t&&"low"!==t)await e.withChildContext(executeRequest,{isReadonly:true,isolationLevel:t,isDeferrable:"high"===t});else await executeRequest(e)},{config:n,locale:i,request:a,response:r,source:"graphql",timeLimitAsTimestamp:o}))}),a}let metadataSchema;function getTenantId(e,t){if(t.tenantId)return t.tenantId;if("test"===e.applicationType)return test_1.Test.defaultTenantId;if(xtrem_config_1.ConfigManager.current.storage.managedExternal)return null;throw new Error("TenantId is not set - cannot execute graphQl Request")}function graphQlMetadata(e){const t=createExpressApp();return t.all("{/*path}",(t,a)=>{setGraphQlTransactionName(t);const r=a.locals.config,n=(0,xtrem_i18n_1.getLocaleFromHeader)(t.headers),i=r.graphql?.timeLimitInSeconds||defaultGraphQlTimeLimitInSeconds({managedExternal:!!r.storage?.managedExternal}),s=performance.now()+1e3*i;return e.requestFunnel(()=>e.withReadonlyContext(getTenantId(e,r),async r=>{if(!await checkTenantId(r,a))return;if(!metadataSchema)metadataSchema=(0,metadata_schema_1.createMetadataSchema)(e);const n=(0,yoga_utils_1.getCommonGraphqlYogaArguments)(metadataSchema,r),i=(0,graphql_yoga_1.createYoga)({...n,graphqlEndpoint:"/metadata",graphiql:{...n.graphiql,defaultQuery:void 0}});await i.handle(t,a)},{config:r,locale:n,request:t,response:a,timeLimitAsTimestamp:s}))}),t}exports.graphQlTimeLimitInSeconds=graphQlTimeLimitInSeconds;
//# sourceMappingURL=graphql-express.js.map