/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.AggregateTypes=exports.groupByVerbsEnumType=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),graphql_1=require("graphql"),ts_api_1=require("../../ts-api"),basic_types_1=require("../types/basic-types"),node_type_1=require("../types/node-type"),property_type_1=require("../types/property-type");exports.groupByVerbsEnumType=(0,basic_types_1.makeCustomEnumOutputType)("Group_Verbs_Enum",ts_api_1.GroupBySelectorDataType);class AggregateTypes{static makeNonNumericAggregateType(e,r){const a={description:`Aggregate type for ${e}`,name:`AggregateTypeFor${e}Property`,fields:{distinctCount:{type:graphql_1.GraphQLInt}}};if(r)a.fields.min={type:r},a.fields.max={type:r},a.fields.hasNull={type:graphql_1.GraphQLBoolean};return new graphql_1.GraphQLObjectType(a)}static{this.aggregateTypes={int:new graphql_1.GraphQLObjectType({description:"Aggregate type for int",name:"AggregateTypeForIntProperty",fields:{min:{type:graphql_1.GraphQLInt},max:{type:graphql_1.GraphQLInt},avg:{type:graphql_1.GraphQLFloat},sum:{type:graphql_1.GraphQLInt},distinctCount:{type:graphql_1.GraphQLInt},hasNull:{type:graphql_1.GraphQLBoolean}}}),integerRange:AggregateTypes.makeNonNumericAggregateType("IntegerRange",basic_types_1.integerRangeType),decimalRange:AggregateTypes.makeNonNumericAggregateType("DecimalRange",basic_types_1.decimalRangeType),integerArray:AggregateTypes.makeNonNumericAggregateType("IntegerArray",basic_types_1.integerArrayType),decimal:new graphql_1.GraphQLObjectType({description:"Aggregate type for decimals",name:"AggregateTypeForDecimalProperty",fields:{min:{type:basic_types_1.decimalType},max:{type:basic_types_1.decimalType},avg:{type:basic_types_1.decimalType},sum:{type:basic_types_1.decimalType},distinctCount:{type:graphql_1.GraphQLInt},hasNull:{type:graphql_1.GraphQLBoolean}}}),date:AggregateTypes.makeNonNumericAggregateType("Date",basic_types_1.dateType),dateRange:AggregateTypes.makeNonNumericAggregateType("DateRange",basic_types_1.dateRangeType),datetimeRange:AggregateTypes.makeNonNumericAggregateType("DatetimeRange",basic_types_1.datetimeRangeType),time:AggregateTypes.makeNonNumericAggregateType("Time",basic_types_1.timeType),datetime:AggregateTypes.makeNonNumericAggregateType("Datetime",basic_types_1.datetimeType),boolean:AggregateTypes.makeNonNumericAggregateType("Boolean",graphql_1.GraphQLBoolean),string:AggregateTypes.makeNonNumericAggregateType("String",graphql_1.GraphQLString),stringArray:AggregateTypes.makeNonNumericAggregateType("StringArray",basic_types_1.stringArrayType),uuid:AggregateTypes.makeNonNumericAggregateType("Uuid"),enum:(e,r)=>{const a=property_type_1.PropertyType.makePropertyGraphQLEnumType(e,void 0,r,"nodeInput"),t=`Enum_${a.name}`;return e.internType(`AggregateTypeFor${t}Property`,()=>AggregateTypes.makeNonNumericAggregateType(t,a))},enumArray:(e,r)=>{const a=`EnumArray_${property_type_1.PropertyType.makePropertyGraphQLEnumType(e,void 0,r,"nodeInput").name}`;return e.internType(`AggregateTypeFor${a}Property`,()=>AggregateTypes.makeNonNumericAggregateType(a))},referenceArray:AggregateTypes.makeNonNumericAggregateType("ReferenceArray"),json:new graphql_1.GraphQLObjectType({description:"Aggregate type for json",name:"AggregateTypeForJsonProperty",fields:{min:{type:basic_types_1.decimalType},max:{type:basic_types_1.decimalType},avg:{type:basic_types_1.decimalType},sum:{type:basic_types_1.decimalType},distinctCount:{type:graphql_1.GraphQLInt},hasNull:{type:graphql_1.GraphQLBoolean}}})}}static parseAstArgs(e){return e.reduce((e,r)=>{const a=r.name.value,t=r.value.value;return e[a]=t,e},{})}static parseAstNodes(e){let r=false;return{values:e.reduce((e,a)=>{if(a.kind===graphql_1.Kind.FIELD){const t=a,s=t.alias?`${t.name.value}|${t.alias.value}`:t.name.value,g=t.name.value;if(t.selectionSet){const r=this.parseAstNodes(t.selectionSet.selections);if(r.containsAggregation){const e=Object.keys(r.values).reduce((e,r)=>(e.$aggregations[r]=true,e),{$aggregations:{}});r.values=e}if(e[s]=r.values,"_customData"===g&&t.arguments)e[s].__args=this.parseAstArgs(t.arguments)}else if(["min","max","avg","sum","distinctCount","hasNull"].includes(g))e[s]=true,r=true;else if(t.arguments)e[s]={__args:this.parseAstArgs(t.arguments)}}return e},{}),containsAggregation:r}}static async parseAggregateNode(e,r,a,t,s){const g=[],p=[];return await(0,xtrem_async_helper_1.asyncArray)(Object.keys(a)).forEach(async n=>{if("__args"===n)return;const i=n.split("|")[0],y=a[n],o=t?[...t,i]:[i],u=r.findProperty(i);if(!await u.isEnabledByServiceOptions(e)||!await u.isAuthorized(e))return void e.addRestrictedPropertyDiagnose(o);if("json"===u.type){if("string"!=typeof y.__args?.selector)throw u.logicError("selector arg missing on json property");if("_customData"===u.name&&!e.customFields[r.fullName])await node_type_1.NodeType.resolveCustomFields(e,r,u);o.push(y.__args.selector)}if(y.$aggregations&&("nodeValues"===s||"edgesValues"===s))Object.keys(y.$aggregations).forEach(e=>{p.push({path:o,operator:e})});else if(y.__args&&"group"===s)g.push({path:o,groupedBy:y.__args.by||"value"});else if(u.isReferenceProperty()){const r=await this.parseAggregateNode(e,u.targetFactory,y,o,s);g.push(...r.groups),p.push(...r.values)}else throw new Error(`Multi-level aggregates can only rely on references ${t}`)}),{groups:g,values:p}}static async parseAggregate(e,r,a){const t=[],s=[],fillResult=async(r,g,p)=>{const n=await this.parseAggregateNode(e,a,r,g,p);return t.push(...n.groups),s.push(...n.values),true},g=this.parseAstNodes(r.fieldNodes).values,p=Object.keys(g).length&&g[Object.keys(g)[0]];if(g.queryAggregate){if(!p.edges)throw new Error("'edges' is missing under 'queryAggregate'");if(!p.edges.node)throw new Error("'node' is missing under 'queryAggregate/edges'");if(!p.edges.node.group)throw new Error("'group' is missing under 'queryAggregate/edges/node'");if(await fillResult(p.edges.node.group,[],"group"),p.edges.node.values)await fillResult(p.edges.node.values,[],"edgesValues")}else if(g.readAggregate)await fillResult(p,[],"nodeValues");else throw new Error(`unsupported ast node name '${r.fieldName}'`);if(0===t.length&&0===s.length)throw new Error("Internal error: AST parse did not find groups or values");return{groups:t,values:s}}static getAggregateType(e,r){switch(r.type){case"boolean":return this.aggregateTypes.boolean;case"decimal":case"float":case"double":return this.aggregateTypes.decimal;case"byte":case"integer":case"short":return this.aggregateTypes.int;case"string":case"date":case"dateRange":case"datetimeRange":case"integerRange":case"decimalRange":case"time":case"datetime":case"uuid":case"integerArray":case"referenceArray":case"stringArray":case"json":return this.aggregateTypes[r.type];case"enumArray":return this.aggregateTypes.enumArray(e,r);case"enum":return this.aggregateTypes.enum(e,r);default:return}}}exports.AggregateTypes=AggregateTypes;
//# sourceMappingURL=aggregate-types.js.map