/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.AggregateQuery=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),graphql_1=require("graphql"),_=require("lodash"),collections_1=require("../../collections"),types_1=require("../../types"),paging_1=require("../paging/paging"),paging_types_1=require("../paging/paging-types"),get_total_count_1=require("../queries/get-total-count"),access_rights_1=require("../security/access-rights"),node_type_1=require("../types/node-type"),aggregate_types_1=require("./aggregate-types");class AggregateQuery{static makeGroupCursor(e){const parseCursor=e=>Object.values(e).map(e=>_.isPlainObject(e)||_.isArray(e)?parseCursor(e):e),t=JSON.stringify(_.flattenDeep(parseCursor(Object.values(e))));return`${t}${(0,types_1.cursorChecksum)(t)}`}static makeGroupNode(e){return{...e,$:{state:{getCursorValue:()=>this.makeGroupCursor(e.group)}}}}static async makePageValue(e,t,r,a,g){const s=r.map(e=>this.makeGroupNode(e));let o=s.length;if(Object.keys(a).some(e=>["first","last","before","after"].includes(e)))o=await e.queryCount(t.nodeConstructor,{..._.omit(a,["first","last","before","after"]),aggregate:g});return paging_1.Paging.buildOutputPage({items:s,totalCount:o},a)}static resolveAggregateQuery(e,t,r,a,g,s){return access_rights_1.AccessRights.runSecure(e,"read",{factory:t,args:s},async()=>{const r=await e.query(t.nodeConstructor,{...a,first:a.first&&a.first+1,last:a.last&&a.last+1,aggregate:g}).toArray();return AggregateQuery.makePageValue(e,t,r,a,g)})}static makeEdgeNodeResolver(e,t,r){return{type:new graphql_1.GraphQLObjectType({name:`${r}_Query_Edges_Node`,fields:{group:{type:node_type_1.NodeType.makeOutputType(e,t,"group")},values:{type:node_type_1.NodeType.makeOutputType(e,t,"values")}}})}}static makeEdgesResolver(e,t,r){return{type:new graphql_1.GraphQLList(new graphql_1.GraphQLObjectType({name:`${r}_Query_Edges`,fields:{node:AggregateQuery.makeEdgeNodeResolver(e,t,r),cursor:{type:graphql_1.GraphQLString}}})),resolve:e=>e.pagePromise.then(e=>e.edges)}}static makePageInfoResolver(){return{type:paging_types_1.pageInfoType,resolve:e=>e.pagePromise?e.pagePromise.then(e=>e.pageInfo):e.pageInfo}}static makeResolver(e,t){const r=`${(0,xtrem_shared_1.schemaTypeName)(t.fullName)}_Agg`,a=`${r}_Query`;return{type:e.internType(a,()=>new graphql_1.GraphQLObjectType({name:a,fields:{edges:AggregateQuery.makeEdgesResolver(e,t,r),pageInfo:AggregateQuery.makePageInfoResolver(),totalCount:get_total_count_1.GetTotalCount.makeResolver(t)}})),args:paging_1.Paging.getPagingArgumentTypes(),resolve(e,r,a,g){const{context:s}=a.xtrem;return access_rights_1.AccessRights.runSecure(s,"read",{factory:t},async()=>{const a=e instanceof collections_1.BaseCollection?e.sourceNode.$.context:s,o=await aggregate_types_1.AggregateTypes.parseAggregate(a,g,t),n=await paging_1.Paging.parsePagingOptions(a,t,r,g,{},o);if(e instanceof collections_1.BaseCollection)await paging_1.Paging.addCollectionFilter(n,e);return{context:a,pagePromise:AggregateQuery.resolveAggregateQuery(a,t,e,n,o,r)}})}}}}exports.AggregateQuery=AggregateQuery;
//# sourceMappingURL=aggregate-query.js.map