/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.addDevUploadRoute=addDevUploadRoute;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_shared_1=require("@sage/xtrem-shared"),fs=require("fs"),fsp=require("path"),application_1=require("../application"),loggers_1=require("../runtime/loggers"),test_1=require("../test"),logger=loggers_1.loggers.fileStorage;function addDevUploadRoute(e,t){const i=xtrem_config_1.ConfigManager.current;if(!(0,xtrem_shared_1.isDevelopmentConfig)(i))return;function parseDestination(e){const o=xtrem_config_1.ConfigManager.current.app,r=o?fsp.join(t.tmpDir,o):t.tmpDir,n=i.tenantId||test_1.Test.defaultTenantId,a=e.params.destination,s=JSON.parse(Buffer.from(e.params.key,"base64").toString()),l=s.objectKey;let d=`${a}/${l}`;const f=s.objectKey.split("/");if("uploads"===a&&f.length>1)d=l;const p=fsp.join(r,n),g=fsp.join(r,n,d);if(!g.startsWith(p))return{relativePath:""};return{destination:a,key:l,filePath:g,rootPath:p,relativePath:d}}const devUploadMiddleware=(e,t,o)=>{const r=i.s3Storage?.s3BucketUrlPrefix;if(r)t.setHeader("access-control-allow-origin",r);o()};e.put("/dev/:destination/:key",devUploadMiddleware,(e,i)=>{const{destination:o,key:r,filePath:n}=parseDestination(e);if(!o||!r||!n)return logger.error(`[Dev] Failed to upload destination=${o} file='${r}' to ${n}`),void i.status(404).end();logger.info(`[Dev] Uploading file destination=${o} file='${r}' to ${n}`),fs.mkdirSync(fsp.dirname(n),{recursive:true});const a=fs.createWriteStream(n);e.pipe(a).on("finish",()=>{let e="";if("uploads"===o||"attachments"===o)e="UploadedFile/InfrastructureComplete";else throw new Error(`Invalid destination ${o}`);const a={contextId:r,result:"success",contextValue:{replyTopic:e}};fs.writeFileSync(`${n}.tags`,JSON.stringify({Key:r,LastModified:Date.now().toString(),ETag:r})),application_1.Application.emitter.emit("devFileUploaded",{application:t,payload:a}),i.status(200).end()}).on("error",e=>{logger.error(`[Dev] Failed to upload destination=${o} file='${r}' from ${n}: ${e.message}`),i.status(404).end(e.message)})}),e.get("/dev/:destination/:key",devUploadMiddleware,(e,t)=>{const{destination:i,key:o,filePath:r,relativePath:n,rootPath:a}=parseDestination(e);if(!(i&&o&&r&&""!==n.trim()&&a))return logger.error(`[Dev] Failed to download destination=${i} file='${o}' from ${r}`),void t.status(404).end();logger.info(`[Dev] Downloading destination=${i} file='${o}' from ${r}`),t.setHeader("content-disposition",`attachment; filename=${e.query.filename?encodeURIComponent(e.query.filename):fsp.basename(r)}`),t.sendFile(n,{root:a},e=>{if(e)logger.error(`[Dev] Failed to download destination=${i} file='${o}' from ${r}: ${e.message}`),t.status(500).send(e.message)})})}
//# sourceMappingURL=dev-upload-middleware.js.map