/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.OperationError=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),_=require("lodash"),loggers_1=require("../runtime/loggers"),error_utils_1=require("./error-utils"),validation_error_1=require("./validation-error"),logger=loggers_1.loggers.core;class OperationError extends xtrem_shared_1.ErrorWithDiagnoses{constructor(r,e,o,t,i){super(e.getLocalizedOperationFailedMessage(r,o),t,i),this.factory=e,this.operation=o,t.forEach(r=>logger.error(()=>JSON.stringify(r)))}static fromNodeMutation(r,e,o,t){return new OperationError(r.$.context,r.$.factory,e,o,t)}static errorMapper(r,e,o){return t=>{if(!(t instanceof validation_error_1.ValidationError))r.diagnoses.push(_.omit((0,error_utils_1.mapErrorToDiagnosis)(r,t),"factoryName"));return new OperationError(r,e,o,r.diagnoses,t)}}}exports.OperationError=OperationError;
//# sourceMappingURL=operation-error.js.map