import { Diagnosis, ErrorWithDiagnoses } from '@sage/xtrem-shared';
import { Context } from '../runtime/context';
import { NodeFactory } from '../system-exports';
import { Node } from '../ts-api/node';
/**
 * GraphQl operation error.
 * The message is localized, and reaches the end user.
 * Contains a list of sanitized diagnoses. Technical details are replaced by a generic message.
 */
export declare class OperationError extends ErrorWithDiagnoses {
    readonly factory: NodeFactory;
    readonly operation: string;
    constructor(context: Context, factory: NodeFactory, operation: string, diagnoses: Diagnosis[], innerError?: Error);
    static fromNodeMutation(node: Node, operation: string, diagnoses: Diagnosis[], innerError?: Error): OperationError;
    static errorMapper(context: Context, factory: NodeFactory, operation: string): (err: Error) => OperationError;
}
//# sourceMappingURL=operation-error.d.ts.map