/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.mapErrorToDiagnosis=mapErrorToDiagnosis;const xtrem_postgres_1=require("@sage/xtrem-postgres"),xtrem_shared_1=require("@sage/xtrem-shared"),diagnosis_builders_1=require("./diagnosis-builders"),postgresForeignKeyViolationErrorCode="23503",postgresUniqueViolationErrorCode="23505",uniqueKeyRegex=/^Key\s*\((?<keys>.*?)\)=/;function mapDatabaseErrorMessage(e,r){if(!(r.code?.startsWith("23")&&r.table&&r.constraint))return(0,diagnosis_builders_1.genericDiagnosis)(e,r,[]);if(r.code===postgresForeignKeyViolationErrorCode){const i=extractSqlContextFromPostgresError(r,e);if(!i)return(0,diagnosis_builders_1.foreignKeyViolationDiagnosis)(e,"UnknownFactory","unknownProperty");const{table:n,foreignKey:o,factoryName:s}=i;if(!o)return(0,diagnosis_builders_1.foreignKeyViolationDiagnosis)(e,s,"unknownProperty");const t=n.factory.properties.find(e=>e.columnName===o.columnNames[o.columnNames.length-1]);if(!t)return(0,diagnosis_builders_1.foreignKeyViolationDiagnosis)(e,s,"unknownProperty");return(0,diagnosis_builders_1.foreignKeyViolationDiagnosis)(e,s,t.name)}if(r.code===postgresUniqueViolationErrorCode){const i=extractSqlContextFromPostgresError(r,e);if(!i)return(0,diagnosis_builders_1.uniqueIndexViolationDiagnosis)(e,"UnknownFactory",[]);const{table:n,factoryName:o}=i,s=r.detail?.match(uniqueKeyRegex)?.groups?.keys;if(!s)return(0,diagnosis_builders_1.uniqueIndexViolationDiagnosis)(e,o,[]);if(!/^[\w\s,]+$/.test(s))return(0,diagnosis_builders_1.uniqueIndexViolationDiagnosis)(e,o,[]);const t=s.split(",").map(e=>e.trim()).filter(e=>"_tenant_id"!==e);if(0===t.length)return(0,diagnosis_builders_1.uniqueIndexViolationDiagnosis)(e,o,[]);const a=t.map(e=>{try{return n.findColumnByColumnName(e)?.property?.name??"<unknown>"}catch{return"<unknown>"}});if(0===a.length)return(0,diagnosis_builders_1.uniqueIndexViolationDiagnosis)(e,o,[]);if(1===a.length)return(0,diagnosis_builders_1.uniqueIndexViolationDiagnosis)(e,o,[a[0]]);return(0,diagnosis_builders_1.uniqueCompositeIndexViolationDiagnosis)(e,o,a.join(", "))}return(0,diagnosis_builders_1.genericDiagnosis)(e,r,[])}function extractSqlContextFromPostgresError(e,r){if(!e.table||!e.constraint)return;let i,n,o;try{i=r.application.getTableByName(e.table),n=i.getForeignKeyByName(e.constraint),o=i.factory.name}catch{return}return{table:i,foreignKey:n,factoryName:o}}function mapErrorToDiagnosis(e,r){if(r instanceof xtrem_shared_1.SystemError&&r.innerError instanceof xtrem_postgres_1.DatabaseError)return mapDatabaseErrorMessage(e,r.innerError);return(0,diagnosis_builders_1.genericDiagnosis)(e,r,r instanceof xtrem_shared_1.BaseError?r.path??[]:[])}
//# sourceMappingURL=error-utils.js.map