/** @packageDocumentation @module decorators */
import { Node } from '../../ts-api';
import { Uuid } from '../../types';
import { InferValT } from '../decorator-utils';
import { TypedPropertyDecorator } from './base-property-decorator';
import { PropertyOverrideDecorator } from './base-property-extension-decorator';
export interface UuidPropertyDecorator<This extends Node = Node, ValT extends Uuid | null = Uuid> extends TypedPropertyDecorator<This, ValT> {
    /** Is property value nullable? */
    isNullable?: boolean;
}
/** &#064;decorators.uuidProperty(arg) property decorator */
export declare function uuidProperty<This extends Node, K extends keyof This>(arg: UuidPropertyDecorator<This, InferValT<This[K], Uuid | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
/** &#064;decorators.uuidPropertyOverride(arg) property decorator */
export declare function uuidPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], Uuid>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
//# sourceMappingURL=uuid-property-decorators.d.ts.map