/** @ignore */ /** */
import { UnPromised } from '@sage/xtrem-async-helper';
import { ColumnTypeName } from '@sage/xtrem-shared';
import { InternalBooleanOrUndefined, Property } from '../properties/property';
import { Node } from '../ts-api';
import { TypedPropertyDecorator } from './property-decorators';
export type StaticThis<T> = new () => T;
export { ColumnTypeName };
export type TypeName = ColumnTypeName | 'instance' | 'reference' | 'collection' | 'jsonReference';
export declare class Decorated {
}
export interface DecoratorArg {
}
export type InferNonNullValT<PropType, ExpectedType> = PropType extends Promise<infer ValT> ? (ValT extends ExpectedType ? ValT : never) : never;
export type InferValT<PropType, ExpectedType> = UnPromised<PropType> extends ExpectedType ? UnPromised<PropType> extends null ? UnPromised<PropType> | null : UnPromised<PropType> : never;
export type NodeFilterTag = 'site';
export type FilterTag = NodeFilterTag | 'accessCode' | 'isActive';
/** Runtime array of all valid FilterTag values */
export declare const FILTER_TAGS: readonly FilterTag[];
/** When merging events from an extension, some events must be chained, meaning that the base event needs
 * to be executed before the extension event. Both events will be executed. */
export declare function chainEvents(baseEvent: any, extEvent: any, key: string): any;
export declare function chainFilters(baseFilter: any, extFilter: any): any;
/** When merging isFrozen from an extension, if any of the base nodes has isFrozen evaluated to true, the property must be frozen
A subnode cannot override the isFrozen attribute with a false value*/
export declare function chainIsFrozens(property: Property, extension: TypedPropertyDecorator): InternalBooleanOrUndefined;
/** Called when an extension extends a list attribute from the base class by adding entries to the list. */
export declare function chainArrays(baseArray: any[] | undefined, extArray: any[] | undefined): any[] | undefined;
export type MemberDecoratorFunction<This extends Decorated, K extends keyof This> = (proto: This, name: K) => void;
export type OperationKind = 'query' | 'mutation' | 'asyncMutation' | 'asyncMutationListener' | 'asyncTrackerQuery' | 'notificationListener' | 'messageListener' | 'bulkMutation';
export type StaticMemberDecoratorFunction<ConstructorType extends typeof Decorated> = (constructor: ConstructorType, name: string) => void;
export declare function staticMemberDecorator<ConstructorType extends typeof Decorated, ArgType extends DecoratorArg>(decoratorName: string, kind: OperationKind): (arg: ArgType) => StaticMemberDecoratorFunction<ConstructorType>;
export type ClassDecoratorFunction<ConstructorType extends typeof Decorated> = (constructor: ConstructorType) => void;
export declare function extendProperty<This extends Node, K extends keyof This>(type: TypeName, arg: any): MemberDecoratorFunction<This, K>;
//# sourceMappingURL=decorator-utils.d.ts.map