/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.wrapError=void 0,exports.runMiddleware=runMiddleware,exports.runResolver=runResolver,exports.safeSetInterval=safeSetInterval,exports.safeSetImmediate=safeSetImmediate,exports.withDetachedClsContext=withDetachedClsContext;const xtrem_log_1=require("@sage/xtrem-log"),xtrem_metrics_1=require("@sage/xtrem-metrics"),xtrem_shared_1=require("@sage/xtrem-shared"),loggers_1=require("./runtime/loggers"),logger=loggers_1.loggers.core,logError=(r,e)=>{const t=e instanceof xtrem_shared_1.SecurityError?e.securityMessage(r):e instanceof xtrem_shared_1.AuthorizationError?e.authorizationMessage(r):e.message;if(e instanceof xtrem_shared_1.BaseError&&e.innerError)logger.error(t),logError(r,e.innerError);else if(e.stack){if(t!==e.message)logger.error(t);logger.error(e.stack)}else logger.error(t)},wrapError=(r,e)=>{if(e instanceof xtrem_shared_1.AuthorizationError)return logError(r,e),e;if(e instanceof xtrem_shared_1.LocalizedError)return e;logError(r,e),(0,xtrem_metrics_1.recordXtremErrorToNewrelic)(r,e);const t=r.cloudflareRayID&&xtrem_log_1.Logger.isLogAsJson()?r.localize("@sage/xtrem-core/generic-error-origin-id","An error occurred. Contact your administrator. Support ID: {{cloudflareRayID}}",{cloudflareRayID:r.cloudflareRayID}):r.localize("@sage/xtrem-core/generic-error","An error occurred. Contact your administrator.");if(e instanceof xtrem_shared_1.LogicError)return new xtrem_shared_1.LogicError(t,e);return new xtrem_shared_1.SystemError(t,e)};async function runWithNewClsContext(r,e){return(0,xtrem_log_1.withClsContext)(r,{context:e})}function runMiddleware(r,e,t){return runWithNewClsContext(e,r).catch(e=>{logError(r,e),t()})}function runResolver(r,e){return runWithNewClsContext(async()=>{if(!r.timeLimitAsTimestamp||r.timeLimitAsTimestamp===Number.MAX_SAFE_INTEGER)return loggers_1.loggers.graphQl.doAsync(e,{ignoreCallback:e=>r.shouldIgnoreDuplicateLogs(e)});const t=r.timeLimitAsTimestamp-performance.now();if(t<=0)throw new xtrem_shared_1.TimeoutError("Request Timeout - no time remaining");const o=new Promise((r,e)=>{setTimeout(()=>{e(new xtrem_shared_1.TimeoutError("Request Timeout - operation exceeded time limit"))},Math.max(t,100))}),s=loggers_1.loggers.graphQl.doAsync(e,{ignoreCallback:e=>r.shouldIgnoreDuplicateLogs(e)});return Promise.race([s,o])},r).catch(e=>{throw(0,exports.wrapError)(r,e)})}function safeSetInterval(r,e){return global.setInterval(()=>{runWithNewClsContext(r).catch(r=>logger.error(r))},e)}function safeSetImmediate(r){return global.setImmediate(()=>{runWithNewClsContext(r).catch(r=>logger.error(r))})}async function withDetachedClsContext(r,e){const t=(0,xtrem_log_1.clsContext)().context;try{return(0,xtrem_log_1.clsContext)().context=r,await e(r)}finally{(0,xtrem_log_1.clsContext)().context=t}}exports.wrapError=wrapError;
//# sourceMappingURL=concurrency-utils.js.map